﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NWCore.DataModel
{
    /// <summary>
    /// カスタムデータモデル用インターフェース
    /// </summary>
    public interface ICustomDataModelList : IList<ICustomDataModelItem>, ICloneable
    {
        /// <summary>Name of the data model.</summary>
        string Name { get; }

        /// <summary>ID of the data model.</summary>
        uint ID { get; }
    }

    /// <summary>
    /// カスタムデータモデル用インターフェース
    /// </summary>
    public interface ICustomDataModelItem : ICloneable
    {
        /// <summary>Name of the field.</summary>
        string Name { get; }

        /// <summary>Type of the field.</summary>
        Type Type { get; }

        /// <summary>Value of the field.</summary>
        object Value { get; }
    }
}
