﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NWCore.DataModel
{
    /// <summary>
    /// ＧＵＩオブジェクトＩＤ。
    /// </summary>
    public enum GuiObjectID
    {
        Nothing = 0,

        // 値は以下の定義と連動している為、変更時は注意して下さい。
        // ・GuiObject._objIconList
        // ・GuiObject._objIconImageList
        // ・UIText._strIDGuiObjectID

        /// <summary>Folder</summary>
        Folder,

        /// <summary>WorkSpace</summary>
        WorkSpace,
        /// <summary>Require</summary>
        Require,

        /// <summary>EffectProject</summary>
        EffectProject,
        /// <summary>EmitterSet</summary>
        EmitterSet,
        /// <summary>Emitter</summary>
        Emitter,
        /// <summary>Child</summary>
        Child,
        /// <summary>Field</summary>
        Field,
        /// <summary>Fluctuation</summary>
        Fluctuation,
        /// <summary>Preview</summary>
        Preview,
        /// <summary>Preview model document</summary>
        PreviewModel,
        /// <summary>Game settings</summary>
        GameSettings,
        /// <summary>Init settings </summary>
        InitSettings

        /// <summary>BoneLinkage</summary>
//        BoneLinkage,
    }
}
