﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_8.Build_0.Revision_0
{
    /// <summary>
    /// アニメーション編集データ
    /// </summary>
    public sealed class AlphaAnimData : BaseDataModel<AlphaAnimData>
    {
        #region Properties

        /// <summary>
        /// アルファアニメタイプ。
        /// </summary>
        public ParticleAnimationTypes AnimType { get; set; }

        /// <summary>
        /// The first alpha value.
        /// </summary>
        public float Alpha1 { get; set; }

        /// <summary>
        /// The second alpha value.
        /// </summary>
        public float Alpha2 { get; set; }

        /// <summary>
        /// The third alpha value.
        /// </summary>
        public float Alpha3 { get; set; }

        /// <summary>
        /// The key frame time.
        /// </summary>
        public int Time1 { get; set; }

        /// <summary>
        /// The key frame time.
        /// </summary>
        public int Time2 { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public AlphaAnimData()
        {
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public AlphaAnimData( AlphaAnimData source )
        {
            this.Set(source);
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.AnimType = ParticleAnimationTypes.InOutAnim;
            this.Alpha1 = 0.0f;
            this.Alpha2 = 1.0f;
            this.Alpha3 = 0.0f;
            this.Time1 = 0;
            this.Time2 = 100;
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 設定
        /// </summary>
        public override void Set( AlphaAnimData source )
        {
            Ensure.Argument.NotNull(source);

            this.AnimType = source.AnimType;
            this.Alpha1 = source.Alpha1;
            this.Alpha2 = source.Alpha2;
            this.Alpha3 = source.Alpha3;
            this.Time1 = source.Time1;
            this.Time2 = source.Time2;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override AlphaAnimData Clone()
        {
            return new AlphaAnimData( this );
        }

        #endregion
    }
}
