﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_7.Build_0.Revision_0
{
    /// <summary>
    /// ランダムフィールド
    /// </summary>
    public sealed class FieldRandomData : BaseDataModel<FieldRandomData>
    {
        #region Properties

        /// <summary>
        /// ランダムをかけるタイミング
        /// </summary>
        public int Blank { get; set; }

        /// <summary>
        /// 速度加算値
        /// </summary>
        public Vector3 VelocityAddition { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public FieldRandomData()
        {
            this.VelocityAddition = new Vector3();    // 速度加算値
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public FieldRandomData(FieldRandomData source)
            : this()
        {
            this.Set(source);
        }

        /// <summary>
        /// Parameter setup コンストラクタ
        /// </summary>
        /// <param name="blank">ランダムをかけるタイミング</param>
        /// <param name="velAdd">速度加算値</param>
        public FieldRandomData(int blank, Vector3 velAdd)
            : this()
        {
            this.Blank = blank;
            this.VelocityAddition.Set(velAdd);
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.Blank = 1;
            this.VelocityAddition.Set(0.0f, 0.0f, 0.0f);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// ベクトルを設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(FieldRandomData source)
        {
            Ensure.Argument.NotNull(source);

            this.Blank = source.Blank;
            this.VelocityAddition = source.VelocityAddition;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override FieldRandomData Clone()
        {
            return new FieldRandomData(this);
        }

        #endregion
    }
}
