﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_7.Build_0.Revision_0
{
    /// <summary>
    /// カールノイズフィールド
    /// </summary>
    public sealed class FieldCurlNoiseData : BaseDataModel<FieldCurlNoiseData>
    {
        #region Properties

        /// <summary>
        /// 渦テーブルの枠サイズ
        /// </summary>
        public bool Interpolation
        {
            get;
            set;
        }
        /// <summary>
        /// 渦テーブルの枠サイズ
        /// </summary>
        public float BorderSize
        {
            get;
            set;
        }
        /// <summary>
        /// 影響の強さ
        /// </summary>
        ///
        public Vector3 Influence
        {
            get;
            set;
        }

        /// <summary>
        /// 渦アニメ速度
        /// </summary>
        public Vector3 Speed
        {
            get;
            set;
        }

        /// <summary>
        /// 渦アニメ初期値
        /// </summary>
        public float InitialValue
        {
            get;
            set;
        }

        /// <summary>
        /// ランダムオフセット
        /// </summary>
        public bool RandomOffset
        {
            get;
            set;
        }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public FieldCurlNoiseData()
        {
            this.Speed = new Vector3(0.0f, 0.0f, 0.0f);
            this.Influence = new Vector3(0.0f, 0.0f, 0.0f);
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public FieldCurlNoiseData(FieldCurlNoiseData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.Interpolation = false;
            this.BorderSize = 1.0f;
            this.Influence.X = 0.05f;
            this.Influence.Y = 0.05f;
            this.Influence.Z = 0.05f;
            this.Speed.X = 0.0f;
            this.Speed.Y = 0.0f;
            this.Speed.Z = 0.0f;
            this.InitialValue = 0.0f;
            this.RandomOffset = false;
        }

        /// <summary>
        /// 設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(FieldCurlNoiseData source)
        {
            Ensure.Argument.NotNull(source);

            this.Interpolation = source.Interpolation;
            this.BorderSize = source.BorderSize;
            this.Influence = source.Influence;
            this.Speed = source.Speed;
            this.InitialValue = source.InitialValue;
            this.RandomOffset = source.RandomOffset;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override FieldCurlNoiseData Clone()
        {
            return new FieldCurlNoiseData(this);
        }

        #endregion
    }
}
