﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Reflection;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NWCore.Serializer.Major_1.Minor_7.Build_0.Revision_0;

namespace NWCore.DataModel.Major_1.Minor_7.Build_0.Revision_0
{
    /// <summary>
    /// EditData用ベースオブジェクト
    /// </summary>
    public abstract class BaseEditData : ICloneable, ISettable, IInitializable
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public BaseEditData()
        {
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public abstract void Initialize();

        /// <summary>
        /// クローン
        /// </summary>
        public abstract object Clone();

        /// <summary>
        /// オブジェクト設定
        /// </summary>
        public abstract void Set(object source);
    }
}
