﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_6.Build_0.Revision_0
{
    /// <summary>
    /// flag for filed magnet
    /// </summary>
    public class FieldMagnetFlag : ISettable
    {
        /// <summary>
        /// Get or set the flags.
        /// </summary>
        public uint Flag
        {
            get
            {
                uint ret = 0;

                if (this.X == true)
                    ret |= (1 << 0);
                if (this.Y == true)
                    ret |= (1 << 1);
                if (this.Z == true)
                    ret |= (1 << 2);

                if (this.FollowEmitter == true)
                    ret |= (1 << 3);

                return ret;
            }
            set
            {
                this.X = (0 != (value & (1 << 0)));
                this.Y = (0 != (value & (1 << 1)));
                this.Z = (0 != (value & (1 << 2)));
                this.FollowEmitter = (0 != (value & (1 << 3)));
            }
        }

        /// <summary>
        /// ISettable用
        /// </summaey>
        public void Set(object source)
        {
            Ensure.Argument.True(source is FieldMagnetFlag);
            this.Flag = (source as FieldMagnetFlag).Flag;
        }

        /// <summary>
        /// X 軸
        /// </summary>
        public bool X { get; set; }

        /// <summary>
        /// Y 軸
        /// </summary>
        public bool Y { get; set; }

        /// <summary>
        /// Z 軸
        /// </summary>
        public bool Z { get; set; }

        /// <summary>
        /// エミッタに追従
        /// </summary>
        public bool FollowEmitter { get; set; }
    }
}
