﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Diagnostics;
using System.Drawing;
using System.Collections.Generic;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_1.Minor_4.Build_0.Revision_0
{
    /// <summary>
    /// エミッタデータ
    /// </summary>
    public class EmitterData : ComplexEmitterData
    {
        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public EmitterData()
        {
            // EditData
            m_editData = new EditDataEmitter();

            //
            this.UI_initRot = new Vector3i();
            this.UI_initRotRand = new Vector3i();
            this.UI_rotBasis = new Vector2();
            this.UI_rotVel = new Vector3i();
            this.UI_rotVelRand = new Vector3i();
            this.UI_transformRot = new Vector3i();
            this.UI_transformScale = new Vector3();
            this.UI_transformTrans = new Vector3();
            this.UI_transformRotRnd = new Vector3i();
            this.UI_transformTransRnd = new Vector3();
            this.UI_hostioEmitterFlg = new EmitterFlag();
            this.EmitterGameData = new EmitterGameData();

            Initialize();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public EmitterData(EmitterData source)
            : this()
        {
            this.Set(source);
        }

        /// <summary>
        /// 初期値の設定
        /// </summary>
        public override void Initialize()
        {
            base.Initialize();

            // EditDataのコピー
            this.EditData.Initialize();

            this.UI_colorType = Constances.ColorCommonType.Modulate;
            this.UI_colorScale = 1.0f;

            this.UI_emitTime = 1;
            this.UI_initRot.Set(0, 0, 0);
            this.UI_initRotRand.Set(0, 0, 0);
            this.UI_isOneTime = false;
            this.UI_rotBasis.Set(0.0f, 0.0f);
            this.UI_rotResist = 1.0f;
            this.UI_rotVel.Set(0, 0, 0);
            this.UI_rotVelRand.Set(0, 0, 0);
            this.UI_transformRot.Set(0, 0, 0);
            this.UI_transformRotUsesMinus180To180Representation = false;
            this.UI_transformScale.Set(1.0f, 1.0f, 1.0f);
            this.UI_transformTrans.Set(0.0f, 0.0f, 0.0f);
            this.UI_transformRotRnd.Set(0, 0, 0);
            this.UI_transformTransRnd.Set(0.0f, 0.0f, 0.0f);

            this.UI_randomType = EmitterRandomTypes.AlwaysGenerate;
            this.UI_randomSeed = 1;

            this.UI_drawPath   = NWKernel.DefaultDrawPath;
            this.UI_drawPathID = NWKernel.DefaultDrawPathID;

            this.UI_combinerSubTextureColorBlend = CombinerBlendTypes.Mod;
            this.UI_combinerPrimitiveColorBlend  = CombinerBlendTypes.Mod;
            this.UI_combinerSubTextureAlphaBlend = CombinerBlendTypes.Mod;
            this.UI_combinerPrimitiveAlphaBlend  = CombinerBlendTypes.Mod;
            this.UI_combinerTextureColorUsage    = CombinerColorUsageTypes.Color;
            this.UI_combinerSubTextureColorUsage = CombinerColorUsageTypes.Color;
            this.UI_combinerPrimitiveColorUsage  = CombinerColorUsageTypes.Color;
            this.UI_combinerTextureAlphaUsage    = CombinerColorUsageTypes.Color;
            this.UI_combinerSubTextureAlphaUsage = CombinerColorUsageTypes.Color;
            this.UI_combinerPrimitiveAlphaUsage  = CombinerColorUsageTypes.Color;

            this.UI_hostioEmitterFlg.Initialize();
            this.EmitterGameData.Initialize();
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// ベクトルを設定します。
        /// </summary>
        /// <param name="source">設定するベクトルです。</param>
        public void Set(EmitterData source)
        {
            Ensure.Argument.NotNull(source);

            // EditDataのコピー
            this.EditData.Set(source.EditData);

            // ComplexEmitterData
            base.Set(source as ComplexEmitterData);

            this.UI_initRot.Set(source.UI_initRot);
            this.UI_initRotRand.Set(source.UI_initRotRand);
            this.UI_rotBasis.Set(source.UI_rotBasis);
            this.UI_rotVel.Set(source.UI_rotVel);
            this.UI_rotVelRand.Set(source.UI_rotVelRand);
            this.UI_transformRot.Set(source.UI_transformRot);
            this.UI_transformRotUsesMinus180To180Representation =
                source.UI_transformRotUsesMinus180To180Representation;
            this.UI_transformScale.Set(source.UI_transformScale);
            this.UI_transformTrans.Set( source.UI_transformTrans );
            this.UI_transformRotRnd.Set( source.UI_transformRotRnd );
            this.UI_transformTransRnd.Set( source.UI_transformTransRnd );
            this.UI_hostioEmitterFlg.Set(source.UI_hostioEmitterFlg);

            this.UI_initVelRnd = source.UI_initVelRnd;
            this.UI_rotResist = source.UI_rotResist;
            this.UI_rotType = source.UI_rotType;
            this.UI_followType = source.UI_followType;
            this.UI_alphaDstType = source.UI_alphaDstType;
            this.UI_scaleRand = source.UI_scaleRand;
            this.UI_fadeAlphaFrameInFade = source.UI_fadeAlphaFrameInFade;
            this.UI_fadeOutType = source.UI_fadeOutType;
            this.UI_colorType = source.UI_colorType;
            this.UI_colorScale = source.UI_colorScale;
            this.UI_emitTime = source.UI_emitTime;
            this.UI_isOneTime = source.UI_isOneTime;
            this.UI_randomType = source.UI_randomType;
            this.UI_randomSeed = source.UI_randomSeed;
            this.UI_stripeHistoryStep = source.UI_stripeHistoryStep;
            this.UI_Fog = source.UI_Fog;

            this.UI_drawPathID = source.UI_drawPathID;
            this.UI_drawPath   = source.UI_drawPath;

            this.UI_combinerSubTextureColorBlend = source.UI_combinerSubTextureColorBlend;
            this.UI_combinerPrimitiveColorBlend  = source.UI_combinerPrimitiveColorBlend;
            this.UI_combinerSubTextureAlphaBlend = source.UI_combinerSubTextureAlphaBlend;
            this.UI_combinerPrimitiveAlphaBlend  = source.UI_combinerPrimitiveAlphaBlend;
            this.UI_combinerTextureColorUsage    = source.UI_combinerTextureColorUsage;
            this.UI_combinerSubTextureColorUsage = source.UI_combinerSubTextureColorUsage;
            this.UI_combinerPrimitiveColorUsage  = source.UI_combinerPrimitiveColorUsage;
            this.UI_combinerTextureAlphaUsage    = source.UI_combinerTextureAlphaUsage;
            this.UI_combinerSubTextureAlphaUsage = source.UI_combinerSubTextureAlphaUsage;
            this.UI_combinerPrimitiveAlphaUsage  = source.UI_combinerPrimitiveAlphaUsage;

            this.EmitterGameData.Set(source.EmitterGameData);
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        new public EmitterData Clone()
        {
            return new EmitterData(this);
        }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であればtrueを返します。</returns>
        public override bool Equals(object other)
        {
            return this.Equals(other as EmitterData);
        }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であればtrueを返します。</returns>
        public bool Equals(EmitterData source)
        {
            // not supposed to come here
            Debug.Assert(false);
            return true;
        }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        /// <returns>ハッシュ値</returns>
        public override int GetHashCode()
        {
            // not supposed to come here
            Debug.Assert(false);
            return -1;
        }

        #endregion

        #region Properties - EditData

        EditDataEmitter m_editData;
        /// <summary>
        /// 編集用のデータ保存用
        /// （バイナリーには影響を与えない保存用データ）
        /// </summary>
        public EditDataEmitter EditData
        {
            get { return m_editData; }
        }

        #endregion

        #region Properties - EmitterData

        /// <summary>
        /// エミッタ位置値
        /// </summary>
        public Vector3 UI_transformTrans { get; set; }

        /// <summary>
        /// エミッタ回転値
        /// </summary>
        public Vector3i UI_transformRot { get; set; }

        /// <summary>
        /// Used to know if the angle was defined using a 0..360 slider
        /// (in which case -180 is meant to be 180) or using a -180..+180 one.
        /// </summary>
        public bool UI_transformRotUsesMinus180To180Representation { get; set;  }

        /// <summary>
        /// エミッタスケール値
        /// </summary>
        public Vector3 UI_transformScale { get; set; }

        /// <summary>
        /// エミッタ位置ランダム幅
        /// </summary>
        public Vector3 UI_transformTransRnd { get; set; }

        /// <summary>
        /// エミッタ回転ランダム幅
        /// </summary>
        public Vector3i UI_transformRotRnd { get; set; }

        /// <summary>
        ///
        /// </summary>
        public PtclRotType UI_rotType { get; set; }

        /// <summary>
        /// カラー共通タイプ
        /// </summary>
        public Constances.ColorCommonType UI_colorType { get; set; }

        /// <summary>
        /// カラースケール
        /// </summary>
        public float UI_colorScale { get; set; }

        /// <summary>
        ///
        /// </summary>
        public FollowType UI_followType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_scaleRand { get; set; }

        /// <summary>
        ///
        /// </summary>
        public float UI_initVelRnd { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_initRot { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_initRotRand { get; set; }

        /// <summary>
        /// 減衰率
        /// </summary>
        public float UI_rotResist { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_rotVel { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector3i UI_rotVelRand { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Vector2 UI_rotBasis { get; set; }

        /// <summary>
        ///
        /// </summary>
        public AlphaDst UI_alphaDstType { get; set; }

        /// <summary>
        /// 描画パスのID
        /// </summary>
        public int UI_drawPathID { get; set; }

        /// <summary>
        /// 描画パス
        /// </summary>
        public string UI_drawPath { get; set; }

        /// <summary>
        /// HostIO編集用のデバッグフラグ
        /// </summary>
        public EmitterFlag UI_hostioEmitterFlg { get; set; }

        /// <summary>
        ///
        /// </summary>
        public bool UI_isOneTime { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_emitTime { get; set; }

        /// <summary>
        /// 乱数タイプ
        /// </summary>
        public EmitterRandomTypes UI_randomType { get; set; }

        /// <summary>
        /// 固定乱数値
        /// </summary>
        public int UI_randomSeed { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_stripeHistoryStep { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_Fog { get; set; }

        /// <summary>
        ///
        /// </summary>
        public FadeOutType UI_fadeOutType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public int UI_fadeAlphaFrameInFade { get; set; }

        /// <summary>
        /// コンバイナ：サブテクスチャカラーの上段との合成。
        /// </summary>
        public CombinerBlendTypes UI_combinerSubTextureColorBlend { get; set; }

        /// <summary>
        /// コンバイナ：プリミティブカラーの上段との合成。
        /// </summary>
        public CombinerBlendTypes UI_combinerPrimitiveColorBlend { get; set; }

        /// <summary>
        /// コンバイナ：サブテクスチャアルファの上段との合成。
        /// </summary>
        public CombinerBlendTypes UI_combinerSubTextureAlphaBlend { get; set; }

        /// <summary>
        /// コンバイナ：プリミティブアルファの上段との合成。
        /// </summary>
        public CombinerBlendTypes UI_combinerPrimitiveAlphaBlend { get; set; }

        /// <summary>
        /// コンバイナ：テクスチャカラーをカラー値か1.0で置き換える。
        /// </summary>
        public CombinerColorUsageTypes UI_combinerTextureColorUsage { get; set; }

        /// <summary>
        /// コンバイナ：サブテクスチャカラーをカラー値か1.0で置き換える。
        /// </summary>
        public CombinerColorUsageTypes UI_combinerSubTextureColorUsage { get; set; }

        /// <summary>
        /// コンバイナ：プリミティブカラーをカラー値か1.0で置き換える。
        /// </summary>
        public CombinerColorUsageTypes UI_combinerPrimitiveColorUsage { get; set; }

        /// <summary>
        /// コンバイナ：テクスチャアルファをアルファ値か1.0で置き換える。
        /// </summary>
        public CombinerColorUsageTypes UI_combinerTextureAlphaUsage { get; set; }

        /// <summary>
        /// コンバイナ：サブテクスチャアルファをアルファ値か1.0で置き換える。
        /// </summary>
        public CombinerColorUsageTypes UI_combinerSubTextureAlphaUsage { get; set; }

        /// <summary>
        /// コンバイナ：プリミティブアルファをアルファ値か1.0で置き換える。
        /// </summary>
        public CombinerColorUsageTypes UI_combinerPrimitiveAlphaUsage { get; set; }


        /// <summary>
        /// エミッタ用ゲーム設定データ
        /// </summary>
        public EmitterGameData EmitterGameData { get; set; }

        #endregion
    }
}
