﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_0.Minor_9.Build_0.Revision_0
{
    /// <summary>
    /// 磁力フィールド
    /// </summary>
    public sealed class FieldMagnetData : BaseDataModel<FieldMagnetData>
    {
        #region Properties

        /// <summary>
        /// 磁力
        /// </summary>
        public float FieldMagnetPower { get; set; }

        /// <summary>
        /// 磁力位置
        /// </summary>
        public Vector3 FieldMagnetPos { get; set; }

        /// <summary>
        /// フラグ
        /// </summary>
        public FieldMagnetFlag Flag { get; set; }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public FieldMagnetData()
        {
            this.FieldMagnetPos = new Vector3();    // 磁力位置
            this.Flag = new FieldMagnetFlag();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public FieldMagnetData(FieldMagnetData source)
            : this()
        {
            this.Set(source);
        }

        /// <summary>
        /// Parameter setup コンストラクタ
        /// </summary>
        /// <param name="power">磁力</param>
        /// <param name="position">磁力位置</param>
        /// <param name="flag">フラグ</param>
        public FieldMagnetData(float power, Vector3 position, FieldMagnetFlag flag)
            : this()
        {
            this.FieldMagnetPower = power;
            this.FieldMagnetPos = position;
            this.Flag.Set(flag);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.Flag.X = true;
            this.Flag.Y = true;
            this.Flag.Z = true;
        }

        /// <summary>
        /// 設定します
        /// </summary>
        public override void Set(FieldMagnetData source)
        {
            Ensure.Argument.NotNull(source);

            this.FieldMagnetPower = source.FieldMagnetPower;

            this.FieldMagnetPos.Set(source.FieldMagnetPos);
            this.Flag.Set(source.Flag);
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override FieldMagnetData Clone()
        {
            return new FieldMagnetData(this);
        }

        #endregion
    }
}
