﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;
using NWCore.DataModel;

namespace NWCore.DataModel.Major_0.Minor_0.Build_0.Revision_0
{
    /// <summary>
    /// 共通設定データ
    /// </summary>
    public sealed class InitialSettingsData : BaseDataModel<InitialSettingsData>
    {
        #region Constructors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public InitialSettingsData()
        {
            Initialize();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public InitialSettingsData(InitialSettingsData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            InitialSettingsFilePath = "";
        }

        /// <summary>
        /// ベクトルを設定します。
        /// </summary>
        /// <param name="source"></param>
        public override void Set(InitialSettingsData source)
        {
            Ensure.Argument.NotNull(source);

            InitialSettingsFilePath = source.InitialSettingsFilePath;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override InitialSettingsData Clone()
        {
            return new InitialSettingsData(this);
        }

        #endregion

        #region Properties

        /// <summary>
        /// 初期設定ファイル
        /// </summary>
        public string InitialSettingsFilePath { get; set; }

        #endregion
    }
}
