﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Reflection;
using System.Resources;

namespace App
{
    /// <summary>
    /// 文字列リソースクラス。
    /// </summary>
    public static class StringResource
    {
        // リソースマネージャ
        private static ResourceManager _resourceManager = null;

        /// <summary>
        /// タイプコンストラクタ。
        /// </summary>
        static StringResource()
        {
            // リソースマネージャ作成
            _resourceManager = new ResourceManager("App.res.Strings", Assembly.GetExecutingAssembly());
        }

        /// <summary>
        /// 文字列取得。
        /// </summary>
        public static string Get(string id)
        {
            lock (_resourceManager)
            {
                string result = _resourceManager.GetString(id);
                Debug.Assert(result != null, string.Format("文字列リソース '{0}' が見つかりません。", id));

                // 見つからない場合でも止まらないように仮文字列を返す
                if (result == null)
                {
                    return "[UNDEFINED STRING]";
                }
                return result;
            }
        }

        /// <summary>
        /// 書式指定して文字列取得。
        /// </summary>
        public static string Get(string id, params object[] args)
        {
            lock (_resourceManager)
            {
                string format = _resourceManager.GetString(id);
                Debug.Assert(format != null, string.Format("文字列リソース '{0}' が見つかりません。", id));

                // 見つからない場合でも止まらないように仮文字列を返す
                if (format == null)
                {
                    return "[UNDEFINED STRING]";
                }
                return string.Format(format, args);
            }
        }
    }
}
