﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

using EffectMaker.Foundation.Log;

namespace EffectMaker.DataModelMaker.UIControls.ConversionView
{
    /// <summary>
    /// The class that manages the connection sources.
    /// </summary>
    internal class ConnectionSourceManager
    {
        /// <summary>The connection sources.</summary>
        private static Dictionary<Guid, ISourceConnectible> sourceConnectibles =
            new Dictionary<Guid, ISourceConnectible>();

        /// <summary>
        /// Register a source connectible.
        /// </summary>
        /// <param name="definitionGuid">The Guid of the source definition.</param>
        /// <param name="connectible">The source connectible.</param>
        public static void RegisterSourceConnectible(
            Guid definitionGuid,
            ISourceConnectible connectible)
        {
            if (sourceConnectibles.ContainsKey(definitionGuid) == true)
            {
                return;
            }

            sourceConnectibles.Add(definitionGuid, connectible);
        }

        /// <summary>
        /// Remove a registered source connectible.
        /// </summary>
        /// <param name="definitionGuid">The Guid of the source definition.</param>
        public static void UnregisterSourceConnectible(Guid definitionGuid)
        {
            sourceConnectibles.Remove(definitionGuid);
        }

        /// <summary>
        /// Clear all the registered source connectibles.
        /// </summary>
        public static void ClearSourceConnectibles()
        {
            sourceConnectibles.Clear();
        }

        /// <summary>
        /// Find the source connectible with the given definition Guid.
        /// </summary>
        /// <param name="definitionGuid">The Guid of the source definition.</param>
        /// <returns>The source connectible if found, otherwise null is returned.</returns>
        public static ISourceConnectible FindSourceConnectible(Guid definitionGuid)
        {
            ISourceConnectible connectible;
            if (sourceConnectibles.TryGetValue(definitionGuid, out connectible) == false)
            {
                return null;
            }

            return connectible;
        }
    }
}
