﻿// ========================================================================
// <copyright file="IRgbaColor.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System;
    using System.ComponentModel;

    /// <summary>
    /// RGBA 成分を保持するカラーのインターフェースです。
    /// </summary>
    public interface IRgbaColor : IColor, INotifyPropertyChanged
    {
        /// <summary>
        /// R 成分を取得または設定します。
        /// </summary>
        new float R { get; set; }

        /// <summary>
        /// B 成分を取得または設定します。
        /// </summary>
        new float B { get; set; }

        /// <summary>
        /// G 成分を取得または設定します。
        /// </summary>
        new float G { get; set; }

        /// <summary>
        /// A 成分を取得または設定します。
        /// </summary>
        new float A { get; set; }

        /// <summary>
        /// アルファが有効か取得します。
        /// </summary>
        bool IsAlphaEnabled { get; }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        /// <param name="r">r 成分です。</param>
        /// <param name="g">g 成分です。</param>
        /// <param name="b">b 成分です。</param>
        /// <param name="a">a 成分です。</param>
        void Set(float r, float g, float b, float a);

        /// <summary>
        /// 値を設定します。
        /// </summary>
        /// <param name="source">設定する値です。</param>
        void Set(IRgbaColor source);

        /// <summary>
        /// IHsvaColor を取得します。
        /// </summary>
        /// <returns>IHsvaColor です。</returns>
        IHsvaColor ToHsvaColor();

        /// <summary>
        /// HSVAでRGBA色を設定します。
        /// </summary>
        /// <param name="h">Hue</param>
        /// <param name="s">Saturation</param>
        /// <param name="v">Value</param>
        /// <param name="a">Alpha</param>
        void FromHsvaColor( float h,
                            float s,
                            float v,
                            float a );
    }
}
