﻿// ========================================================================
// <copyright file="Vector3ArrayMetaData.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    /// <summary>
    /// データに関するVector3配列型属性情報を表すためのクラスです。
    /// </summary>
    public class Vector3ArrayMetaData : ArrayMetaData<Vector3>
    {
        //-----------------------------------------------------------------
        // コンストラクタ
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public Vector3ArrayMetaData()
        {
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="arrayMetaData">コピー元です。</param>
        private Vector3ArrayMetaData(Vector3ArrayMetaData arrayMetaData)
        {
            this.Set(arrayMetaData);
        }

        //-----------------------------------------------------------------
        // メソッド
        //-----------------------------------------------------------------

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>このインスタンスのコピーである新しいオブジェクトです。</returns>
        public override object Clone()
        {
            return new Vector3ArrayMetaData(this);
        }
    }
}
