﻿// ========================================================================
// <copyright file="EditMetaDataXml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System;
    using System.ComponentModel;

    /// <summary>
    /// エディタメタデータの基本クラスです。
    /// <remarks>
    /// IMetaDataを実装し、クローンコピーされてデータモデルに直接保持されます。
    /// CoupledType属性で自分自身にコピー指定を行うようにします。
    /// </remarks>
    /// </summary>
    public abstract class EditMetaDataXml : ArrayMetaDataXml, IMetaData
    {
        private string key;

        /// <summary>
        /// プロパティ変更イベント
        /// </summary>
        public event PropertyChangedEventHandler PropertyChanged;

        /// <summary>
        /// データを検索する際のキーワードです。
        /// </summary>
        public override string Key
        {
            get
            {
                return this.key;
            }

            set
            {
                if (this.key == value)
                {
                    return;
                }

                this.key = value;
                this.OnPropertyChanged("Key");
            }
        }

        /// <summary>
        /// オブジェクトの複製を作成します。
        /// </summary>
        /// <returns>
        /// オブジェクトの複製です。
        /// </returns>
        public abstract object Clone();

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public abstract void Set(object source);

        /// <summary>
        /// プロパティ変更イベントの発動です。
        /// </summary>
        /// <param name="args">プロパティ変更イベントの引数です。</param>
        protected virtual void OnPropertyChanged(PropertyChangedEventArgs args)
        {
            if (this.PropertyChanged != null)
            {
                this.PropertyChanged(this, args);
            }
        }

        /// <summary>
        /// プロパティ変更イベントの発動です。
        /// </summary>
        /// <param name="propertyName">変更したプロパティの名前です。</param>
        protected virtual void OnPropertyChanged(string propertyName)
        {
            this.OnPropertyChanged(new PropertyChangedEventArgs(propertyName));
        }
    }
}
