﻿// ========================================================================
// <copyright file="IXmlSerializedContent.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    /// <summary>
    /// XMLシリアライザでシリアライズ処理される、データを表現するクラスです。
    /// </summary>
    public interface IXmlSerializedContent : IXmlContent
    {
        /// <summary>
        /// シリアライズ結果インスタンスを取得または設定します。
        /// </summary>
        object SerializeInstance { get; set; }
    }

    /// <summary>
    /// XMLシリアライザでシリアライズ処理される、データを表現するクラスです。
    /// </summary>
    /// <typeparam name="TSerializedType">シリアライズ処理されるデータ型です。</typeparam>
    public interface IXmlSerializedContent<TSerializedType> : IXmlSerializedContent
        where TSerializedType : class
    {
        /// <summary>
        /// シリアライズ結果インスタンスを取得または設定します。
        /// </summary>
        new TSerializedType SerializeInstance { get; set; }
    }
}
