﻿// ========================================================================
// <copyright file="IXmlComplexDocument.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Xml.Complex
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;

    /// <summary>
    /// 複合 XML ドキュメントです。
    /// ルート直下の要素毎に入出力処理を切り替えられる XML ドキュメントです。
    /// </summary>
    public interface IXmlComplexDocument : ICloneable, INotifyPropertyChanged, ISettable
    {
        /// <summary>
        /// ルート要素の名前を取得または設定します。
        /// </summary>
        string RootElementName { get; set; }

        /// <summary>
        /// コンテンツリストを取得または設定します。
        /// </summary>
        IList<IXmlContent> Contents { get; set; }
    }
}
