﻿// ========================================================================
// <copyright file="LogLocation.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Logs
{
    using System;
    using NintendoWare.ToolDevelopmentKit.ComponentModel;

    /// <summary>
    /// ログ出力位置です。
    /// </summary>
    public abstract class LogLocation : ObservableObject, ILogLocation
    {
#if DEBUG
        //-----------------------------------------------------------------
        private readonly string stackTrace = Environment.StackTrace;

        //-----------------------------------------------------------------
        // プロパティの取得または設定
        //-----------------------------------------------------------------

        /// <summary>
        /// デバッグ用のスタックトレースを取得します。
        /// </summary>
        public string StackTrace
        {
            get
            {
                return this.stackTrace;
            }
        }
#else
        // using System; 保護コード
        private void SaveUsingSystem()
        {
            int tickCount = Environment.TickCount;
        }
#endif
    }
}
