﻿// ========================================================================
// <copyright file="ChildListDecorator.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System;
    using System.Collections.Generic;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// 親を持つオブジェクトリストのデコレータです。
    /// </summary>
    /// <typeparam name="TParent">親のテンプレート型です。</typeparam>
    /// <typeparam name="TItem">要素のテンプレート型です。</typeparam>
    [Obsolete]
    public class ChildListDecorator<TParent, TItem> : ListDecorator<TItem>
        where TParent : class
        where TItem : class, IChildObject<TParent>
    {
        //-----------------------------------------------------------------
        private readonly TParent parent = null;

        //-----------------------------------------------------------------
        // オブジェクトの生成
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="list">デコレーションするリストです。</param>
        /// <param name="parent">要素に設定する親です。</param>
        public ChildListDecorator(IList<TItem> list, TParent parent)
            : base(list)
        {
            Ensure.Argument.NotNull(parent);

            this.parent = parent;
        }

        //-----------------------------------------------------------------
        // 要素の取得または設定
        //-----------------------------------------------------------------

        /// <summary>
        /// 要素に設定する親を取得します。
        /// </summary>
        protected virtual TParent Parent
        {
            get
            {
                return this.parent;
            }
        }

        /// <summary>
        /// 指定したインデックス位置へのアクセスを行うインデクサです。
        /// </summary>
        /// <param name="index">アクセスする項目の 0 から始まるインデックスです。</param>
        /// <returns>インデックス位置の項目です。</returns>
        public override TItem this[int index]
        {
            set
            {
                // ソート等のために自リストへの項目代入を許可する
                Ensure.Argument.True(
                    (value == null) || (value.Parent == null) || (value.Parent == this.Parent));

                TItem swap = base[index];
                Ensure.Operation.True((swap == null) || (swap.Parent == this.Parent));

                base[index] = value;

                if (value != null)
                {
                    value.Parent = this.Parent;
                }

                // アイテムが取り除かれる場合は親を初期化します。
                if (swap != value && swap != null && !this.Contains(swap))
                {
                    swap.Parent = null;
                }
            }
        }

        //-----------------------------------------------------------------
        // 要素の追加または削除
        //-----------------------------------------------------------------

        /// <summary>
        /// 指定したインデックス位置に項目を挿入します。
        /// </summary>
        /// <param name="index">項目を挿入する位置の、0 から始まるインデックス番号です。</param>
        /// <param name="item">挿入する項目です。</param>
        public override void Insert(int index, TItem item)
        {
            if (item != null)
            {
                // ソート等のために自リストへの項目代入を許可する
                Ensure.Argument.True((item.Parent == null) || (item.Parent == this.Parent));

                // Parentの更新を完了後、基底の処理を呼びます(変更イベントの発行などが起こります）。
                item.Parent = this.Parent;
                base.Insert(index, item);
            }
            else
            {
                base.Insert(index, item);
            }
        }

        /// <summary>
        /// 指定したインデックス位置の項目を削除します。
        /// </summary>
        /// <param name="index">削除する項目の 0 から始まるインデックスです。</param>
        public override void RemoveAt(int index)
        {
            TItem item = this[index];
            Ensure.Operation.True((item == null) || (item.Parent == this.Parent));

            // Parentの更新を完了後、基底の処理を呼びます(変更イベントの発行などが起こります）。
            if (item != null)
            {
                item.Parent = null;
            }

            base.RemoveAt(index);
        }

        /// <summary>
        /// すべての項目を削除します。
        /// </summary>
        public override void Clear()
        {
            foreach (TItem item in this)
            {
                Ensure.Operation.True((item == null) || (item.Parent == this.Parent));

                item.Parent = null;
            }

            base.Clear();
        }
    }
}
