﻿// ========================================================================
// <copyright file="IPreviewModelDocument.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Text;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel
{
    /// <summary>
    /// プレビュードキュメント
    /// </summary>
    public interface IPreviewModelDocument : IDocument, IShowable
    {
        /// <summary>
        /// 親のプレビュードキュメント
        /// </summary>
        IPreviewDocument PreviewDocument { get; }

        /// <summary>
        /// データモデル
        /// </summary>
        PreviewModelData PreviewModelData { get; }

        /// <summary>
        /// ドキュメントインデックス
        /// </summary>
        int DocumentIndex { get; }
    }
}
