﻿// ========================================================================
// <copyright file="DocumentRenamer.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;
//using App.Controls;
using App.Data;
using App.Utility;
using NWCore.DataModel;

namespace App.IO
{
    /// <summary>
    /// ドキュメントリネーマ。
    /// </summary>
    public sealed class DocumentRenamer
    {
        /// <summary>
        /// リネーム開始。
        /// </summary>
        public void BeginRename()
        {
        }

        /// <summary>
        /// リネーム終了。
        /// </summary>
        public void EndRename(NodeLabelEditEventArgs args)
        {
        }

        //---------------------------------------------------------------------
        /// <summary>
        /// 拡張子の追加。
        /// </summary>
        private bool AddExtension(ref string fileName, Document document)
        {
            string extension = "." + document.FileExt;
            if (!fileName.EndsWith(extension))
            {
                fileName += extension;
                return true;
            }
            return false;
        }

        /// <summary>
        /// 重複した名前のチェック。
        /// </summary>
        private bool CheckSameNamed(IDocument document, string fileName)
        {
            {
                foreach (IDocument doc in DocumentManager.Documents)
                {
                    if (doc.FileName == fileName) { return false; }
                }
            }
            return true;
        }

        /// <summary>
        /// 名前の変更。
        /// </summary>
        private DocumentNameChangedArgs ChangeName(IDocument document, string fileName)
        {
            DocumentNameChangedArgs args = new DocumentNameChangedArgs(document, document.Name);
            document.Name = Path.GetFileNameWithoutExtension(fileName);
            document.ClearFileLocation();
            return args;
        }

        //---------------------------------------------------------------------
        // 無効なファイル名
        private static void ErrorInvalidFileName(string fileName)
        {
            string message = string.Format(res.Strings.IO_INVALID_FILE_NAME_MSG, fileName);
            /*
            ThreadSafeMsgBox.Show( message,
                                   res.Strings.WARNING_CAPTION,
                                   System.Windows.Forms.MessageBoxButtons.OK,
                                   System.Windows.Forms.MessageBoxIcon.Warning );
            */
        }

        // ファイル名重複エラー。
        private void ErrorFileNameCollision(string fileName)
        {
            string message = string.Format(res.Strings.IO_FILENAME_COLLISION_MSG, fileName);
            /*
            ThreadSafeMsgBox.Show( message,
                                   res.Strings.WARNING_CAPTION,
                                   System.Windows.Forms.MessageBoxButtons.OK,
                                   System.Windows.Forms.MessageBoxIcon.Warning );
            */
        }
    }
}
