﻿// ========================================================================
// <copyright file="DocumentIOUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System.Collections.Generic;
using System.IO;
//using App.Controls;
using App.Data;
using App.Utility;

namespace App.IO
{
    /// <summary>
    /// ドキュメントIOユーティリティ。
    /// </summary>
    public static class DocumentIOUtility
    {
        //---------------------------------------------------------------------
        /// <summary>
        /// 保存先ディレクトリの確認。
        /// </summary>
        public static bool ConfirmSaveDirectory( ref string directoryPath,
                                                 bool bSilent = false )
        {
            // Empty string?
            if ( string.IsNullOrEmpty(directoryPath)==true )
            {
                /*
                if ( bSilent==false )
                    ThreadSafeMsgBox.Show( res.Strings.IO_SAVE_DIRECTORY_SPECIFY_MSG,
                                           res.Strings.WARNING_CAPTION,
                                           System.Windows.Forms.MessageBoxButtons.OK,
                                           System.Windows.Forms.MessageBoxIcon.Warning );
                */
                return false;
            }

            // Directory exists?
            if ( Directory.Exists(directoryPath)==false )
            {
                /*
                if ( bSilent==false )
                    ThreadSafeMsgBox.Show( res.Strings.IO_SAVE_DIRECTORY_NOT_FOUND_MSG,
                                           res.Strings.WARNING_CAPTION,
                                           System.Windows.Forms.MessageBoxButtons.OK,
                                           System.Windows.Forms.MessageBoxIcon.Warning );
                */
                return false;
            }

            // パスの末尾を調整
            if ( directoryPath.EndsWith("\\") ||
                 directoryPath.EndsWith("/") )
            {
                directoryPath = directoryPath.Substring( 0, directoryPath.Length - 1 );
            }

            return true;
        }
    }
}
