﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

//using App.Command;
using App.IO;
using NWCore.DataModel;
using NWCore.Utility;

namespace App.Data
{
    public static class TextureResourceHelper
    {
        /// <summary>
        /// Increment the unreachable and typeMismatch counters accordingly.
        /// </summary>
        /// <param name="texturePath">Path to the texture</param>
        /// <param name="unreachableAssetCount">Unreachable asset counter</param>
        /// <param name="typeMismatchTextureCount">Type mismtach counter</param>
        public static void CheckTextureReachability(string texturePath, ref int unreachableAssetCount, ref int typeMismatchTextureCount)
        {
            if (DocumentConstants.NoSuchAssetPath(texturePath) == true)
            {
                ++unreachableAssetCount;
            }

            TextureInfo info = null;
            TheApp.TextureManager.GetTextureInfo(texturePath, out info);
            if (info != null &&
                 TheApp.TextureManager.CheckTextureLinearEditMode(info, false) != TextureManager.TextureTypeCheckResult.OK)
            {
                ++typeMismatchTextureCount;
            }
        }

        /// <summary>
        /// Creates and send a command for when a texture is modified from outside.
        /// </summary>
        /// <param name="docPath">Texture resource docPath</param>
        /// <param name="sender">Document issuing the command</param>
        /// <param name="textureRes">Texture resource</param>
        public static void IssueTextureResourceModifiedCommand( string docPath,
                                                                IDocument sender,
                                                                TextureRes textureRes )
        {
            /*
            // Create the command argument with the
            // texture resource(bitmaps) as data source.
            PropertyEditCommandArgs args =
                new PropertyEditCommandArgs( new NWCore.Utility.Path(string.Empty),
                                             new NWCore.Utility.Path(docPath),
                                             sender,
                                             textureRes,
                                             textureRes );

            // Create a command to notify that the bitmaps has changed.
            ICommand cmd = PropertyEditCommand.CreateCommand(args);

            // Just let the command finish without executing.
            // We only want the command to notify the data source listeners.
            cmd.FinishExecution(CommandExecutionTypes.Execute);
            */
        }

        /// <summary>
        /// Read a texture and issue a corresponding command.
        /// </summary>
        /// <param name="docPath">Texture resource docPath</param>
        /// <param name="sender">Document issuing the command</param>
        /// <param name="textureRes">Texture resource</param>
        /// <param name="texPatFileName">UI path of the file location</param>
        public static void ReadTextureAndIssueCommand( string docPath,
                                                       Path commandControlPath,
                                                       IDocument sender,
                                                       TextureRes textureRes,
                                                       ref string texPatFileName )
        {
            // Load texture file
            string fullPath = String.Empty;
            if (DocumentIO.ReadTextureFile( sender.FileLocation,
                                            texPatFileName,
                                            textureRes,
                                            ref fullPath) == true )
            {
                string origFilePath = texPatFileName;
                texPatFileName = fullPath;

                TextureInfo texInfo = textureRes.TextureInfo;
                if (null != texInfo)
                {
                    TheApp.TextureManager.CheckTextureLinearEditMode(texInfo, true);
                }

                // Create the command argument with the
                // texture file name as data source.
                /*
                PropertyEditCommandArgs args =
                    new PropertyEditCommandArgs( commandControlPath,
                                                 new NWCore.Utility.Path(docPath),
                                                 sender,
                                                 origFilePath,
                                                 texPatFileName );

                // Create a command to notify that the bitmaps has changed.
                ICommand cmd = PropertyEditCommand.CreateCommand(args);

                // Just let the command finish without executing.
                // We only want the command to notify the data source listeners.
                cmd.FinishExecution(CommandExecutionTypes.Execute);
                */
            }
        }
    }
}
