﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare
  File:     eft_Particle.fsh

  Copyright (C)2011-2012 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/




//------------------------------------------------------------------------------
// テクスチャ0 カラーを取得する( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_GET_TEXTURE_COLOR
vec4 GetTexture0Color( vec2 texCoord )
{
#ifdef _TEX_0_SURFACE_ANIM

#ifdef _TEX_0_SURFACE_ANIM_CROSSFADE
    float term            = texPatAnim0.pm.x * texPatAnim0.pm.w - 1;
    float texRatio        = sysLifeRatio * term;
#else
    float texRatio        = sysLifeRatio * texPatAnim0.pm.x * texPatAnim0.pm.w;
#endif
    int wrap              = int( texRatio / texPatAnim0.pm.x );
    texRatio              = texRatio - texPatAnim0.pm.x * wrap;
    float frac            = fract( texRatio );
    float index0          = texRatio - frac;
#ifdef _TEX_0_SURFACE_ANIM_CROSSFADE
    float index1          = index0 + 1;
    index1                = mod( index1, texPatAnim0.pm.x );
    vec3 tex_coord0       = vec3( texCoord.xy, index0 );
    vec3 tex_coord1       = vec3( texCoord.xy, index1 );
    vec4 textureColor     = texture( sysTextureSampler0, tex_coord0 );
    vec4 textureColorNext = texture( sysTextureSampler0, tex_coord1 );
    vec4 color            = mix( textureColor, textureColorNext, frac );
#else
    vec3 tex_coord0       = vec3( texCoord.xy, index0 );
    vec4 color            = texture( sysTextureSampler0, tex_coord0 );
#endif


#else

#ifndef _TEX0_MIPMAP_LEVEL_LIMIT
    vec4 color = texture2D( sysTextureSampler0, texCoord );
#else
    float lod = textureQueryLod( sysTextureSampler0, texCoord ).x;
    lod = min( lod, MIPMAPLEVEL_LIMIT );
    vec4 color = textureLod( sysTextureSampler0, texCoord, lod );
#endif

#endif

    float src_a = color.a;

    // RGB二乗
#ifdef _TEX0_COLOR_INPUT_SQUARE
    color.rgb = color.rgb * color.rgb;
#endif

    // アルファ調整
#ifdef _TEX0_ALPHA_INPUT_ONE
    color.a = 1.0;
#endif
#ifdef _TEX0_ALPHA_INPUT_RED
    color.a = color.r;
#endif
#ifdef _TEX0_ALPHA_INPUT_ONE_MINUS_RED
    color.a = 1.0 - color.r;
#endif
#ifdef _TEX0_ALPHA_INPUT_ONE_MINUS_ALPHA
    color.a = 1.0 - color.a;
#endif

    // カラー調整
#ifdef _TEX0_COLOR_INPUT_ONE
    color.rgb = vec3( 1 );
#endif
#ifdef _TEX0_COLOR_INPUT_ONE_MINUS_RGB
    color.rgb = vec3( 1 ) - color.rgb;
#endif
#ifdef _TEX0_COLOR_INPUT_ALPHA
#ifdef _REVERT_SDK_3_1_0_FIX
    color.rgb = color.aaa;
#else
    color.r = src_a;
    color.g = src_a;
    color.b = src_a;
#endif
#endif
#ifdef _TEX0_COLOR_INPUT_ONE_MINUS_ALPHA
#ifdef _REVERT_SDK_3_1_0_FIX
    color.rgb = vec3( 1 ) - color.aaa;
#else
    color.r = 1 - src_a;
    color.g = 1 - src_a;
    color.b = 1 - src_a;
#endif
#endif
    return color;
}
#endif




//------------------------------------------------------------------------------
// テクスチャ1 カラーを取得する( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_GET_TEXTURE1_COLOR
vec4 GetTexture1Color( vec2 texCoord )
{
#ifdef _TEX_1_SURFACE_ANIM

#ifdef _TEX_1_SURFACE_ANIM_CROSSFADE
    float term            = texPatAnim1.pm.x * texPatAnim1.pm.w - 1;
    float texRatio        = sysLifeRatio * term;
#else
    float texRatio        = sysLifeRatio * texPatAnim1.pm.x * texPatAnim1.pm.w;
#endif
    int wrap              = int( texRatio / texPatAnim1.pm.x );
    texRatio              = texRatio - texPatAnim1.pm.x * wrap;
    float frac            = fract( texRatio );
    float index0          = texRatio - frac;
#ifdef _TEX_1_SURFACE_ANIM_CROSSFADE
    float index1          = index0 + 1;
    index1                = mod( index1, texPatAnim1.pm.x );
    vec3 tex_coord0       = vec3( texCoord.xy, index0 );
    vec3 tex_coord1       = vec3( texCoord.xy, index1 );
    vec4 textureColor     = texture( sysTextureSampler1, tex_coord0 );
    vec4 textureColorNext = texture( sysTextureSampler1, tex_coord1 );
    vec4 color            = mix( textureColor, textureColorNext, frac );
#else
    vec3 tex_coord0       = vec3( texCoord.xy, index0 );
    vec4 color            = texture( sysTextureSampler1, tex_coord0 );
#endif

#else

#ifndef _TEX1_MIPMAP_LEVEL_LIMIT
    vec4 color = texture2D( sysTextureSampler1, texCoord );
#else
    float lod = textureQueryLod( sysTextureSampler1, texCoord ).x;
    lod = min( lod, MIPMAPLEVEL_LIMIT );
    vec4 color = textureLod( sysTextureSampler1, texCoord, lod );
#endif

#endif

    float src_a = color.a;

    // RGB二乗
#ifdef _TEX1_COLOR_INPUT_SQUARE
    color.rgb = color.rgb * color.rgb;
#endif

    // アルファ調整
#ifdef _TEX1_ALPHA_INPUT_ONE
    color.a = 1.0;
#endif
#ifdef _TEX1_ALPHA_INPUT_RED
    color.a = color.r;
#endif
#ifdef _TEX1_ALPHA_INPUT_ONE_MINUS_RED
    color.a = 1.0 - color.r;
#endif
#ifdef _TEX1_ALPHA_INPUT_ONE_MINUS_ALPHA
    color.a = 1.0 - color.a;
#endif

    // カラー調整
#ifdef _TEX1_COLOR_INPUT_ONE
    color.rgb = vec3( 1 );
#endif
#ifdef _TEX1_COLOR_INPUT_ONE_MINUS_RGB
    color.rgb = vec3( 1 ) - color.rgb;
#endif
#ifdef _TEX1_COLOR_INPUT_ALPHA
#ifdef _REVERT_SDK_3_1_0_FIX
    color.rgb = color.aaa;
#else
    color.r = src_a;
    color.g = src_a;
    color.b = src_a;
#endif
#endif
#ifdef _TEX1_COLOR_INPUT_ONE_MINUS_ALPHA
#ifdef _REVERT_SDK_3_1_0_FIX
    color.rgb = vec3( 1 ) - color.aaa;
#else
    color.r = 1 - src_a;
    color.g = 1 - src_a;
    color.b = 1 - src_a;
#endif
#endif
    return color;
}
#endif





//------------------------------------------------------------------------------
// テクスチャ2 カラーを取得する( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_GET_TEXTURE2_COLOR
vec4 GetTexture2Color( vec2 texCoord )
{
#ifdef _TEX_2_SURFACE_ANIM

#ifdef _TEX_2_SURFACE_ANIM_CROSSFADE
    float term            = texPatAnim2.pm.x * texPatAnim2.pm.w - 1;
    float texRatio        = sysLifeRatio * term;
#else
    float texRatio        = sysLifeRatio * texPatAnim2.pm.x * texPatAnim2.pm.w;
#endif
    int wrap              = int( texRatio / texPatAnim2.pm.x );
    texRatio              = texRatio - texPatAnim2.pm.x * wrap;
    float frac            = fract( texRatio );
    float index0          = texRatio - frac;
#ifdef _TEX_2_SURFACE_ANIM_CROSSFADE
    float index1          = index0 + 1;
    index1                = mod( index1, texPatAnim2.pm.x );
    vec3 tex_coord0       = vec3( texCoord.xy, index0 );
    vec3 tex_coord1       = vec3( texCoord.xy, index1 );
    vec4 textureColor     = texture( sysTextureSampler2, tex_coord0 );
    vec4 textureColorNext = texture( sysTextureSampler2, tex_coord1 );
    vec4 color            = mix( textureColor, textureColorNext, frac );
#else
    vec3 tex_coord0       = vec3( texCoord.xy, index0 );
    vec4 color            = texture( sysTextureSampler2, tex_coord0 );
#endif

#else


#ifndef _TEX2_MIPMAP_LEVEL_LIMIT
    vec4 color = texture2D( sysTextureSampler2, texCoord );
#else
    float lod = textureQueryLod( sysTextureSampler2, texCoord ).x;
    lod = min( lod, MIPMAPLEVEL_LIMIT );
    vec4 color = textureLod( sysTextureSampler2, texCoord, lod );
#endif

#endif

    float src_a = color.a;

    // RGB二乗
#ifdef _TEX2_COLOR_INPUT_SQUARE
    color.rgb = color.rgb * color.rgb;
#endif

    // アルファ調整
#ifdef _TEX2_ALPHA_INPUT_ONE
    color.a = 1.0;
#endif
#ifdef _TEX2_ALPHA_INPUT_RED
    color.a = color.r;
#endif
#ifdef _TEX2_ALPHA_INPUT_ONE_MINUS_RED
    color.a = 1.0 - color.r;
#endif
#ifdef _TEX2_ALPHA_INPUT_ONE_MINUS_ALPHA
    color.a = 1.0 - color.a;
#endif

    // カラー調整
#ifdef _TEX2_COLOR_INPUT_ONE
    color.rgb = vec3( 1 );
#endif
#ifdef _TEX2_COLOR_INPUT_ONE_MINUS_RGB
    color.rgb = vec3( 1 ) - color.rgb;
#endif
#ifdef _TEX2_COLOR_INPUT_ALPHA
#ifdef _REVERT_SDK_3_1_0_FIX
    color.rgb = color.aaa;
#else
    color.r = src_a;
    color.g = src_a;
    color.b = src_a;
#endif
#endif
#ifdef _TEX2_COLOR_INPUT_ONE_MINUS_ALPHA
#ifdef _REVERT_SDK_3_1_0_FIX
    color.rgb = vec3( 1 ) - color.aaa;
#else
    color.r = 1 - src_a;
    color.g = 1 - src_a;
    color.b = 1 - src_a;
#endif
#endif
    return color;
}
#endif




//---------------------------------------------------
// プリミティブ頂点カラーを取得する( カスタマイズ可能 )
//---------------------------------------------------
#ifndef USE_USR_GET_PRIMITIVE_COLOR
vec3 GetPrimitiveColor()
{
#ifdef _PRIMITIVE_COLOR_INPUT_SRC
    return sysPrimitiveColorVary.xyz;
#endif
#ifdef _PRIMITIVE_COLOR_INPUT_ONE
    return vec3( 1.0, 1.0, 1.0 );
#endif
#ifdef _PRIMITIVE_COLOR_INPUT_ONE_MINUS_RGB
    return vec3( 1 ) - sysPrimitiveColorVary.xyz;
#endif
#ifdef _PRIMITIVE_COLOR_INPUT_ALPHA
    return sysPrimitiveColorVary.www;
#endif
#ifdef _PRIMITIVE_COLOR_INPUT_ONE_MINUS_ALPHA
    return vec3( 1 ) - sysPrimitiveColorVary.www;
#endif
}
#endif




//---------------------------------------------------
// プリミティブ頂点アルファを取得する( カスタマイズ可能 )
//---------------------------------------------------
#ifndef USE_USR_GET_PRIMITIVE_COLOR
float GetPrimitiveAlpha()
{
#ifdef _PRIMITIVE_ALPHA_INPUT_A
    return sysPrimitiveColorVary.w;
#endif
#ifdef _PRIMITIVE_ALPHA_INPUT_RED
    return sysPrimitiveColorVary.x;
#endif
#ifdef _PRIMITIVE_ALPHA_INPUT_ONE
    return 1.0;
#endif
#ifdef _PRIMITIVE_ALPHA_INPUT_ONE_MINUS_RED
    return 1.0 - sysPrimitiveColorVary.x;
#endif
#ifdef _PRIMITIVE_ALPHA_INPUT_ONE_MINUS_ALPHA
    return 1.0 - sysPrimitiveColorVary.w;
#endif
}
#endif




//---------------------------------------------------
// プリミティブカラーをブレンドする( カスタマイズ可能 )
//---------------------------------------------------
vec3 BlendPrimitiveColor( vec3 outputColor, vec3 primitiveColor )
{
    vec3 retColor;
#ifdef _PRIMITIVE_COLOR_BLEND_MOD
    retColor   = outputColor * primitiveColor;
#endif
#ifdef _PRIMITIVE_COLOR_BLEND_ADD
    retColor   = outputColor + primitiveColor;
#endif
#ifdef _PRIMITIVE_COLOR_BLEND_SUB
    retColor   = outputColor - primitiveColor;
#endif
    return retColor;
}




//---------------------------------------------------
// プリミティブアルファをブレンドする( カスタマイズ可能 )
//---------------------------------------------------
vec4 BlendPrimitiveAlpha( vec4 texture, float primitiveAlpha )
{
    float retAlpha = texture.a;
#ifdef _PRIMITIVE_ALPHA_BLEND_MOD
    retAlpha   = retAlpha * primitiveAlpha;
#endif
#ifdef _PRIMITIVE_ALPHA_BLEND_ADD
    retAlpha   = retAlpha + primitiveAlpha;
#endif
#ifdef _PRIMITIVE_ALPHA_BLEND_SUB
    retAlpha   = retAlpha - primitiveAlpha;
#endif
    texture.a = retAlpha;
    return texture;
}




//---------------------------------------------------
// フレームバッファテクスチャカラーを取得する( カスタマイズ可能 )
//---------------------------------------------------
#ifndef USE_USR_GET_FRAME_BUFFER_VALUE
vec4 GetFrameBufferTextureColor( vec4 projection )
{
    return texture2DProj( sysFrameBufferTexture, projection );
}
#endif





//---------------------------------------------------
// デプス値を取得する( カスタマイズ可能 )
//---------------------------------------------------
#ifndef USE_USR_GET_DEPTH_VALUE
float GetDepthValue( vec4 position )
{
    // 射影変換結果を varying 変数で持ってきているので、深度値化に position.w で除算するのが必要
    // ※ 頂点シェーダのテクスチャ座標変換で [-1,1] -> [0,1] に変換されてるがこれはOK？
    float depth = position.z / position.w;
    // [0,1] -> [Near,Far] の値域に Map。Near は0に近い（0.1とか）ので、実質[0, Far] の近似ともみなせる。
    // ※ EffectMaker/Viewer のデフォルト設定では [0.1, 1000] の値域になる。
    depth = - ( sysScreenFarMultNearFar ) / ( depth * ( sysScreenSubFarNear ) - sysScreenFar );
    return depth;
}
#endif




//---------------------------------------------------
// デプステクスチャからデプス値を取得する( カスタマイズ可能 )
//---------------------------------------------------
#ifndef USE_USR_GET_DEPTH_VALUE_FROM_TEXTURE
float GetDepthValueFromTexture( vec4 projection )
{
    float depth = texture2DProj( sysDepthBufferTexture, projection ).r;
    depth = - ( sysScreenFarMultNearFar ) / ( depth * ( sysScreenSubFarNear ) - sysScreenFar );
    return depth;
}
#endif




//---------------------------------------------
// 最終出力カラー調整
//---------------------------------------------
#ifndef USE_USR_FINAL_ADJUSTMENT_FRAGMENT_COLOR
void FinalAdjustmentFragmentColor(){}
#endif




//------------------------------------------------------------------------------
// カラー計算式処理を行う
//------------------------------------------------------------------------------
#ifndef USE_USR_GET_FRAGMENT_COLOR
vec3 GetFragmentColor( vec3 texture, vec3 vcolor0, vec3 vcolor1 )
{
#ifdef _COLOR_PROCESS_COLOR
    return vcolor0;
#endif
#ifdef _COLOR_PROCESS_TEXTURE
    return texture * vcolor0;
#endif
#ifdef _COLOR_PROCESS_TEXTURE_INTERPOLATE
    return mix( vcolor1, vcolor0, texture );
#endif
#ifdef _COLOR_PROCESS_TEXTURE_ADD
    return texture * vcolor0 + vcolor1;
#endif
}
#endif




//------------------------------------------------------------------------------
// アルファ計算式処理を行う
//------------------------------------------------------------------------------
#ifndef USE_USR_GET_FRAGMENT_ALPHA
float GetFragmentAlpha( float texture, float alpha0, float alpha1 )
{
#ifdef _ALPHA_PROCESS_MOD
    return texture * alpha0;
#endif
#ifdef _ALPHA_PROCESS_SUB
    return ( texture - ( 1.0 - alpha0 ) ) * 2.0;
#endif
#ifdef _ALPHA_PROCESS_MOD_A0_A1
    return texture * alpha0 * alpha1;
#endif
#ifdef _ALPHA_PROCESS_SUB_A0_MOD_A1
    return ( texture - alpha0 ) * alpha1;
#endif
#ifdef _ALPHA_PROCESS_DIST_FILED
    float ret = ( texture - alpha0 ) * 4.0;
    return clamp( ret, 0.0, 1.0 ) * alpha1;
#endif
}
#endif




//------------------------------------------------------------------------------
// テクスチャ1をブレンドする( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_BLEND_TEXTURE1_COLOR
vec4 BlendTexture1Color( vec4 texture0, vec4 texture1 )
{
    vec4 ret;

#ifdef _TEXTURE1_COLOR_BLEND_MOD
    ret.rgb = texture0.rgb * texture1.rgb;
#endif
#ifdef _TEXTURE1_COLOR_BLEND_ADD
    ret.rgb = texture0.rgb + texture1.rgb;
#endif
#ifdef _TEXTURE1_COLOR_BLEND_SUB
    ret.rgb = texture0.rgb - texture1.rgb;
#endif

#ifdef _TEXTURE1_ALPHA_BLEND_MOD
    ret.a   = texture0.a * texture1.a;
#endif
#ifdef _TEXTURE1_ALPHA_BLEND_ADD
    ret.a   = texture0.a + texture1.a;
#endif
#ifdef _TEXTURE1_ALPHA_BLEND_SUB
    ret.a   = texture0.a - texture1.a;
#endif
    return ret;
}
#endif




//------------------------------------------------------------------------------
// テクスチャ2をブレンドする( カスタマイズ可能 )
//------------------------------------------------------------------------------
#ifndef USE_USR_BLEND_TEXTURE2_COLOR
vec4 BlendTexture2Color( vec4 texture0, vec4 texture2 )
{
    vec4 ret;

#ifdef _TEXTURE2_COLOR_BLEND_MOD
    ret.rgb = texture0.rgb * texture2.rgb;
#endif
#ifdef _TEXTURE2_COLOR_BLEND_ADD
    ret.rgb = texture0.rgb + texture2.rgb;
#endif
#ifdef _TEXTURE2_COLOR_BLEND_SUB
    ret.rgb = texture0.rgb - texture2.rgb;
#endif

#ifdef _TEXTURE2_ALPHA_BLEND_MOD
    ret.a   = texture0.a * texture2.a;
#endif
#ifdef _TEXTURE2_ALPHA_BLEND_ADD
    ret.a   = texture0.a + texture2.a;
#endif
#ifdef _TEXTURE2_ALPHA_BLEND_SUB
    ret.a   = texture0.a - texture2.a;
#endif
    return ret;
}
#endif




//---------------------------------------------------
// ソフトエッジ処理( カスタマイズ可能 )
//---------------------------------------------------
#ifndef USE_USR_SOFT_EDGE
float CalculateSoftEdge()
{
    // ピクセルZを取得する
    float pz = GetDepthValue( sysFragCoordVary );

    // テクスチャからZ値を取得する
    float tz = GetDepthValueFromTexture( sysFragCoordVary );
/*
    // テクスチャの輝度を計算する
    float luminance = dot( OUTPUT_COLOR.rgb, vec3( 0.298912, 0.586611, 0.114478 ) );
    luminance = - ( sysScreenFarMultNearFar ) / ( clamp( luminance * softEdgeVolume, 0, 1 )  * ( subFarNearZ ) - farZ );
    luminance *= step( 0.001, addVecToScale.z );
    // シーンZ/ピクセルZ/ボリューム値を考慮してアルファ値を決定する
    float dis = tz - ( pz - luminance );
*/
    float dis = tz - pz;

    // アルファ処理
    dis /= addVecToScale.y;
    dis = clamp( dis, 0.0, 1.0 );
    return mix( 0.0, 1.0, dis );
}
#endif




//----------------------------------------------------
// 共通アルファ処理処理
//----------------------------------------------------
float CalcAlphaProcess( float inAlpha )
{
    float ret = clamp( inAlpha, 0.0, 1.0 );

#ifdef _FRAGMENT_SOFT
    // ソフトエッジ処理
    ret *= CalculateSoftEdge();
#endif

#ifdef _FRAGMENT_FRESNEL_ALPHA
    // フレネル アルファ
    ret *= CalcFresnelRate( sysEyeVecVary.xyz, sysWorldNormalVary );
#endif

#ifdef _DECAL
    // デカール
    #define decalVolume     alphaFunc2.x
    float tz  = GetDepthValueFromTexture( sysFragCoordVary );
    float pz  = GetDepthValue( sysFragCoordVary );
    float dis = abs( tz - pz );
    float rate = 1 - step( decalVolume, dis );
    ret *= rate;
#endif

//  ret = clamp( ret * sysMasterAlpha, 0.0, 1.0 );
    ret = ret * sysMasterAlpha;

#ifdef _USE_NN_VFX

#ifdef _ALPHA_COMPARE_NEVER
    discard;
#endif

#ifdef _ALPHA_COMPARE_LESS
    if ( ret >= alphaFunc2.z )
    {
        discard;
    }
#endif

#ifdef _ALPHA_COMPARE_EQUAL
    if ( ret != alphaFunc2.z )
    {
        discard;
    }
#endif

#ifdef _ALPHA_COMPARE_LEQUAL
    if ( ret > alphaFunc2.z )
    {
        discard;
    }
#endif

#ifdef _ALPHA_COMPARE_GREATER
    if ( ret <= alphaFunc2.z )
    {
        discard;
    }
#endif

#ifdef _ALPHA_COMPARE_NOTEQUAL
    if ( ret == alphaFunc2.z )
    {
        discard;
    }
#endif

#ifdef _ALPHA_COMPARE_GEQUAL
    if ( ret < alphaFunc2.z )
    {
        discard;
    }
#endif

#ifdef _ALPHA_COMPARE_ALWAYS
    /* DO NOTHING */
#endif

#endif

    return ret;
}




//------------------------------------------------------------------------------
// 通常シェーダ
//------------------------------------------------------------------------------
#ifdef _SHADER_TYPE_NORMAL
void main()
{
#if 0

    OUTPUT_COLOR.r = 1;
    OUTPUT_COLOR.g = 1;
    OUTPUT_COLOR.b = 1;
    OUTPUT_COLOR.a = 1;

#else

    vec4 texture0 = vec4( 1 );

    // テクスチャ0を処理
#ifdef _TEXTURE0_ENABLE
    texture0 = GetTexture0Color( sysInTexCoord0 );
#endif

    // テクスチャ1を処理
#ifdef _TEXTURE1_ENABLE
    vec4 texture1 = GetTexture1Color( sysInTexCoord1 );
    texture0 = BlendTexture1Color( texture0, texture1 );
#endif

    // テクスチャ2を処理
#ifdef _TEXTURE2_ENABLE
    vec4 texture2 = GetTexture2Color( sysInTexCoord2 );
    texture0 = BlendTexture2Color( texture0, texture2 );
#endif

    // テクスチャカラーとパーティクルカラーをブレンド
    OUTPUT_COLOR.rgb = GetFragmentColor( texture0.rgb, sysColor0Vary.rgb, sysColor1Vary.rgb );

#ifdef _PRIMITIVE
    // プリミティブカラー反映
    OUTPUT_COLOR.rgb = BlendPrimitiveColor( OUTPUT_COLOR.rgb, GetPrimitiveColor() );

    // プリミティブ利用時は頂点アルファをブレンド
    texture0 = BlendPrimitiveAlpha( texture0, GetPrimitiveAlpha() );
#endif

    // テクスチャアルファとパーティクルアルファを乗算
    OUTPUT_COLOR.a = GetFragmentAlpha( texture0.a, sysColor0Vary.a, sysColor1Vary.a );

    // アルファ処理
    OUTPUT_COLOR.a = CalcAlphaProcess( OUTPUT_COLOR.a );

#endif

    // カスタムシェーダによる最終カラー出力調整
    FinalAdjustmentFragmentColor();

}
#endif




//------------------------------------------------------------------------------
// 屈折シェーダ
//------------------------------------------------------------------------------
#ifdef _SHADER_TYPE_REFRACT
void main()
{
    // テクスチャ0(屈折係数)を処理
#ifdef _TEXTURE0_ENABLE
    vec4 texture0 = GetTexture0Color( sysInTexCoord0 );
    texture0.xy = texture0.xy * 2.0 - 1.0;

#ifdef _REFRACT_BY_CAMERA_DISTANCE
    texture0.xy *= sysFragCoordVary.w;
#else
    texture0.xy *= 25;  // 係数合わせ
#endif

#else
    vec4 texture0 = vec4( 0.5 );
#endif

    // 屈折係数を乗算する
    texture0.x *= shaderCoef.x * sysShaderAnim;
#ifdef _TEXTURE_ORIGIN_LOWER_LEFT
    texture0.y *= -shaderCoef.y * sysShaderAnim;
#endif
#ifdef _TEXTURE_ORIGIN_UPPER_LEFT
    texture0.y *= shaderCoef.y * sysShaderAnim;
#endif
    texture0.xy *= texture0.w;  // テクスチャ0のαを乗算

#ifdef _TEXTURE1_ENABLE
    vec4 texture1 = GetTexture1Color( sysInTexCoord1 );
#endif
#ifdef _TEXTURE2_ENABLE
    vec4 texture2 = GetTexture2Color( sysInTexCoord2 );
#endif

#if defined( _TEXTURE1_ENABLE ) && defined( _REFRACT_APPLY_ALPHA )
    texture0.xy *= texture1.w;
#endif
#if defined( _TEXTURE2_ENABLE ) && defined( _REFRACT_APPLY_ALPHA )
    texture0.xy *= texture2.w;
#endif

    // フレームバッファテクスチャカラーを取得する
    vec4 screenCrd;
    texture0.z = 0.0;
    texture0.w = 0.0;
    screenCrd   = sysFragCoordVary + texture0;
    texture0    = GetFrameBufferTextureColor( screenCrd );
    texture0.a  = 1.0;

    // テクスチャ1を処理
#ifdef _TEXTURE1_ENABLE
    texture0 = BlendTexture1Color( texture0, texture1 );
#endif

    // テクスチャ2を処理
#ifdef _TEXTURE2_ENABLE
    texture0 = BlendTexture2Color( texture0, texture2 );
#endif

    // テクスチャカラーとパーティクルカラーをブレンド
    OUTPUT_COLOR.rgb = GetFragmentColor( texture0.rgb, sysColor0Vary.rgb, sysColor1Vary.rgb );

#ifdef _PRIMITIVE
    // プリミティブカラー反映
    OUTPUT_COLOR.rgb = BlendPrimitiveColor( OUTPUT_COLOR.rgb, GetPrimitiveColor() );

    // プリミティブ利用時は頂点アルファをブレンド
    texture0 = BlendPrimitiveAlpha( texture0, GetPrimitiveAlpha() );
#endif

    // テクスチャアルファとパーティクルアルファを乗算
    OUTPUT_COLOR.a = GetFragmentAlpha( texture0.a, sysColor0Vary.a, sysColor1Vary.a );

    // アルファ処理
    OUTPUT_COLOR.a = CalcAlphaProcess( OUTPUT_COLOR.a );

    // カスタムシェーダによる最終カラー出力調整
    FinalAdjustmentFragmentColor();
}
#endif




//------------------------------------------------------------------------------
// 歪みシェーダ
//------------------------------------------------------------------------------
#ifdef _SHADER_TYPE_DISTORTION
void main()
{
    // 歪み係数
    float ratioX = shaderCoef.x * sysShaderAnim;
    float ratioY = shaderCoef.y * sysShaderAnim;

    // テクスチャ0(歪み係数)を処理
#ifdef _TEXTURE0_ENABLE
    vec4 texture0 = GetTexture0Color( sysInTexCoord0 ) * 2.0 - 1.0;
    //texture0 *= sysFragCoordVary.w;
#else
    vec4 texture0 = vec4( 0.5 );
#endif

    // 歪みテクスチャ座標を求める
    vec2 distCoord;
    distCoord.x = sysInTexCoord1.x + texture0.x * ratioX;
    distCoord.y = sysInTexCoord1.y + texture0.w * ratioY;

    // テクスチャ1を処理
#ifdef _TEXTURE1_ENABLE
    texture0 = GetTexture1Color( distCoord );
#endif

    // テクスチャ2を処理
#ifdef _TEXTURE2_ENABLE
    vec4 texture2 = GetTexture2Color( sysInTexCoord2 );
    texture0 = BlendTexture2Color( texture0, texture2 );
#endif

    // テクスチャカラーとパーティクルカラーをブレンド
    OUTPUT_COLOR.rgb = GetFragmentColor( texture0.rgb, sysColor0Vary.rgb, sysColor1Vary.rgb );

#ifdef _PRIMITIVE
    // プリミティブカラー反映
    OUTPUT_COLOR.rgb = BlendPrimitiveColor( OUTPUT_COLOR.rgb, GetPrimitiveColor() );

    // プリミティブ利用時は頂点アルファをブレンド
    texture0 = BlendPrimitiveAlpha( texture0, GetPrimitiveAlpha() );
#endif

    // テクスチャアルファとパーティクルアルファを乗算
    OUTPUT_COLOR.a = GetFragmentAlpha( texture0.a, sysColor0Vary.a, sysColor1Vary.a );

    // アルファ処理
    OUTPUT_COLOR.a = CalcAlphaProcess( OUTPUT_COLOR.a );

    // カスタムシェーダによる最終カラー出力調整
    FinalAdjustmentFragmentColor();
}
#endif

