﻿/*---------------------------------------------------------------------------*
 Copyright (C) 2013 Nintendo Co., Ltd.  All rights reserved.

 These coded instructions, statements, and computer programs contain
 proprietary information of Nintendo of America Inc. and/or Nintendo
 Company Ltd., and are protected by Federal copyright law.  They may
 not be disclosed to third parties or copied or duplicated in any form,
 in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/


//------------------------------------------------------------------------------
// 定義
//------------------------------------------------------------------------------
// フラグメントシェーダであることの定義
#define FRAGMENT_SHADER


//------------------------------------------------------------------------------
// Varying 置き換え
//------------------------------------------------------------------------------
#define _VARYING_IN     varying

//------------------------------------------------------------------------------
// 入力
//------------------------------------------------------------------------------
_VARYING_IN vec4     sysColor0Vary;                        // カラー0


#if defined( _COLOR_PROCESS_TEXTURE_INTERPOLATE ) || defined( _COLOR_PROCESS_TEXTURE_ADD )
_VARYING_IN vec4     sysColor1Vary;                        // カラー1
#endif

#ifdef _PRIMITIVE
_VARYING_IN vec4     sysPrimitiveColorVary;                // プリミティブカラー
#endif

#if defined( _TEXTURE0_ENABLE ) || defined( _TEXTURE1_ENABLE )
_VARYING_IN vec4     sysTexCoord01Vary;                    // テクスチャ座標0-1
#define     sysInTexCoord0 sysTexCoord01Vary.xy
#define     sysInTexCoord1 sysTexCoord01Vary.zw
#endif

#ifdef _TEXTURE2_ENABLE
_VARYING_IN vec2     sysTexCoord2Vary;                     // テクスチャ座標2
#define     sysInTexCoord2 sysTexCoord2Vary
#endif

_VARYING_IN vec4     sysFlagParamVary;                     // 各種パラメータ( alphaRate )

#if defined( _SHADER_TYPE_REFRACT ) || defined( _SHADER_TYPE_DISTORTION )
_VARYING_IN vec4     sysFlagCoordVary;                     // スクリーン座標参照用
#endif





//------------------------------------------------------------------------------
// カラー出力先
// システムは最終カラーをここに書き込みます。
// 書き込み先を変えたい場合は、カスタムフラグメントシェーダーにて、
// OUTPUT_COLOR を #undef し再定義して下さい。
//------------------------------------------------------------------------------
#define OUTPUT_COLOR gl_FragColor


