﻿

//------------------------------------------------------------------------------
// main
//------------------------------------------------------------------------------
#ifndef USE_USR_VERTEX_MAIN
void main()
{

    //-----------------------------------------------------------------
    // カラー
    sysColor0Vary = sysColor0Attr * sysEmitterColor0;

#if defined( _COLOR_PROCESS_TEXTURE_INTERPOLATE ) || defined( _COLOR_PROCESS_TEXTURE_ADD )
    sysColor1Vary = sysColor1Attr * sysEmitterColor1;
#endif

#ifdef _PRIMITIVE
    sysPrimitiveColorVary = sysVertexColor0Attr;
#endif


    // パーティクル時間
    sysPtclTime = sysEmitterTime - sysPtclEmitTime;

#ifdef EFT_USE_INSTANS_DRAW
    // CPUパーティクル時には、sysPtclEmitTimeが InitRot.w に書かれるため、
    // パーティクル時間が負になり、不正なタイミングで描画される可能性がある。
    if ( sysPtclTime < 0.0 )
    {
        // カメラから見えない点に飛ばしてカリングさせる。
        // フラグメントシェーダに入れないのが目的。
        gl_Position.z = sysScreenFar * 5.0;
        gl_Position.x = gl_Position.y = 0.0;
        return;
    }

    // 寿命を全うしたパーティクルは描画しない
    if ( sysPtclTime >= sysPtclLife )
    {
        gl_Position.z = sysScreenFar * 5.0;
        gl_Position.x = gl_Position.y = 0.0;
        return;
    }
#endif

    //---------------------------------
    // エミッタRTマトリクス生成
#ifdef _EMITTER_FOLLOW_TYPE_ALL
    sysEmitterRT[0] = sysEmitterRTMatrix[0];
    sysEmitterRT[1] = sysEmitterRTMatrix[1];
    sysEmitterRT[2] = sysEmitterRTMatrix[2];
#endif
#ifdef _EMITTER_FOLLOW_TYPE_POS
    sysEmitterRT[0] = vec4( sysEmtRTMat0Attr.xyz, sysEmitterMatrix[0].w );
    sysEmitterRT[1] = vec4( sysEmtRTMat1Attr.xyz, sysEmitterMatrix[1].w );
    sysEmitterRT[2] = vec4( sysEmtRTMat2Attr.xyz, sysEmitterMatrix[2].w );
#endif
#ifdef _EMITTER_FOLLOW_TYPE_NONE
    sysEmitterRT[0] = sysEmtRTMat0Attr;
    sysEmitterRT[1] = sysEmtRTMat1Attr;
    sysEmitterRT[2] = sysEmtRTMat2Attr;
#endif


    //-----------------------------------------------------------------
    // パーティクルの回転値を生成
#if defined( _USE_ROTATE )

    float rSinX = sin( sysInitRotateAttr.x );
    float rCosX = cos( sysInitRotateAttr.x );

    float rSinY = sin( sysInitRotateAttr.y );
    float rCosY = cos( sysInitRotateAttr.y );

    float rSinZ = sin( sysInitRotateAttr.z );
    float rCosZ = cos( sysInitRotateAttr.z );

    float opt1 = rSinX * rSinY;
    float opt2 = rCosX * rSinY;
    float opt3 = rSinX * rCosY;
    float opt4 = rCosX * rCosY;

    sysPtclRotateMatrix[0][0] =  rCosY * rCosZ;
    sysPtclRotateMatrix[0][1] =  opt4 * rSinZ + opt1;
    sysPtclRotateMatrix[0][2] =  opt3 * rSinZ - opt2;
    sysPtclRotateMatrix[0][3] =  0.0;

    sysPtclRotateMatrix[1][0] = -rSinZ;
    sysPtclRotateMatrix[1][1] =  rCosZ * rCosX;
    sysPtclRotateMatrix[1][2] =  rCosZ * rSinX;
    sysPtclRotateMatrix[1][3] =  0.0;

    sysPtclRotateMatrix[2][0] =  rSinY * rCosZ;
    sysPtclRotateMatrix[2][1] =  opt2 * rSinZ - opt3;
    sysPtclRotateMatrix[2][2] =  opt1 * rSinZ + opt4;
    sysPtclRotateMatrix[2][3] =  0.0;

    sysPtclRotateMatrix[3][0] = 0.0;
    sysPtclRotateMatrix[3][1] = 0.0;
    sysPtclRotateMatrix[3][2] = 0.0;
    sysPtclRotateMatrix[3][3] = 1.0;

#endif

    // スケール
    sysPtclScale.xyz = sysScaleAttr.xyz;

    // パーティクルのローカル位置をCPUで計算済み入力値を利用
    sysPtclLocalPos = sysLocalPosAttr.xyz;

    // パーティクル中心世界座標
#ifdef _EMITTER_FOLLOW_TYPE_ALL
    //sysPtclWorldPos = ( vec4( sysPtclLocalPos, 1.0 ) * sysEmitterMatrix ).xyz;
    sysPtclWorldPos.x = dot( sysEmitterMatrix[0] , vec4( sysPtclLocalPos, 1.0 ) );
    sysPtclWorldPos.y = dot( sysEmitterMatrix[1] , vec4( sysPtclLocalPos, 1.0 ) );
    sysPtclWorldPos.z = dot( sysEmitterMatrix[2] , vec4( sysPtclLocalPos, 1.0 ) );
#endif
#ifdef _EMITTER_FOLLOW_TYPE_POS
    vec4 m0 = vec4( sysEmtMat0Attr.xyz, sysEmitterMatrix[0].w );
    vec4 m1 = vec4( sysEmtMat1Attr.xyz, sysEmitterMatrix[1].w );
    vec4 m2 = vec4( sysEmtMat2Attr.xyz, sysEmitterMatrix[2].w );
    sysPtclWorldPos.x = dot( m0 , vec4( sysPtclLocalPos, 1.0 ) );
    sysPtclWorldPos.y = dot( m1 , vec4( sysPtclLocalPos, 1.0 ) );
    sysPtclWorldPos.z = dot( m2 , vec4( sysPtclLocalPos, 1.0 ) );
#endif
#ifdef _EMITTER_FOLLOW_TYPE_NONE
    sysPtclWorldPos.x = dot( sysEmtMat0Attr , vec4( sysPtclLocalPos, 1.0 ) );
    sysPtclWorldPos.y = dot( sysEmtMat1Attr , vec4( sysPtclLocalPos, 1.0 ) );
    sysPtclWorldPos.z = dot( sysEmtMat2Attr , vec4( sysPtclLocalPos, 1.0 ) );
#endif


    // パーティクル移動差分
#if defined( _PARTICLE_TYPE_VEL_LOOK ) || defined( _PARTICLE_TYPE_VEL_LOOK_POLYGON )
#ifdef _EMITTER_FOLLOW_TYPE_ALL
    sysPtclWorldPosDelta.x = dot( vec4( sysEmitterMatrix[0].xyz, 0.0 ), vec4( sysLocalDiffAttr.xyz, 1.0 ) );
    sysPtclWorldPosDelta.y = dot( vec4( sysEmitterMatrix[1].xyz, 0.0 ), vec4( sysLocalDiffAttr.xyz, 1.0 ) );
    sysPtclWorldPosDelta.z = dot( vec4( sysEmitterMatrix[2].xyz, 0.0 ), vec4( sysLocalDiffAttr.xyz, 1.0 ) );
#else
    sysPtclWorldPosDelta.x = dot( vec4( sysEmitterRT[0].xyz, 0.0 ), vec4( sysLocalDiffAttr.xyz, 1.0 ) );
    sysPtclWorldPosDelta.y = dot( vec4( sysEmitterRT[1].xyz, 0.0 ), vec4( sysLocalDiffAttr.xyz, 1.0 ) );
    sysPtclWorldPosDelta.z = dot( vec4( sysEmitterRT[2].xyz, 0.0 ), vec4( sysLocalDiffAttr.xyz, 1.0 ) );
#endif
#endif

    // パーティクルタイプ挙動計算
    vec3 particleOffset;
    particleOffset.x = particleParam.z;
    particleOffset.y = particleParam.w;
    particleOffset.z = 0.0;
    vec3 localPos = ( sysPosAttr.xyz + particleOffset ) * sysPtclScale.xyz;

    //---------------------------------
    // ビルボード, Y軸ビルボード, 立体風ビルボード
#if defined( _PARTICLE_TYPE_BILLBOARD ) || defined( _PARTICLE_TYPE_Y_BILLBOARD ) || defined( _PARTICLE_TYPE_Y_BILLBOARD_PARALLEL ) || defined( _PARTICLE_TYPE_WITH_SCALE_Z ) || defined( _PARTICLE_TYPE_WITH_SCALE_Z_DIRECTIONAL )
#ifdef _USE_ROTATE
     mat4 transposeMat   = transpose( bldMat ) * sysPtclRotateMatrix;
#else
     mat4 transposeMat   = transpose( bldMat );
#endif

#ifdef _USE_ROTATE
    vec3 temp = ( sysPtclRotateMatrix * vec4( localPos, 1 ) ).xyz;
    gl_Position.xyz = ( vec4( temp, 1 ) * bldMat ).xyz + sysPtclWorldPos;
#else
    gl_Position.xyz = ( vec4( localPos, 1 ) * bldMat ).xyz + sysPtclWorldPos;
#endif
#endif


    //---------------------------------
    // 高機能 ポリゴン
#ifdef _PARTICLE_TYPE_COMPLEX_BILLBOARD
    // ビルボードマトリクス
    vec3 viewUp = vec3( sysViewMatrix[1].x, sysViewMatrix[1].y, sysViewMatrix[1].z );

    vec3 zAxis = normalize( sysEyePosition.xyz - sysPtclWorldPos.xyz );
    vec3 xAxis = normalize( cross( zAxis, -viewUp ) );
    vec3 yAxis = cross( zAxis, xAxis );

    mat4 cmpBillboardMat = mat4(
        xAxis.x, yAxis.x, zAxis.x, 0,
        xAxis.y, yAxis.y, zAxis.y, 0,
        xAxis.z, yAxis.z, zAxis.z, 0,
              0,       0,       0, 1
        );

#ifdef _USE_ROTATE
    mat4 transposeMat   = transpose( cmpBillboardMat ) * sysPtclRotateMatrix;
    vec3 temp = ( sysPtclRotateMatrix * vec4( localPos, 1 ) ).xyz;
    gl_Position.xyz = ( vec4( temp, 1 ) * cmpBillboardMat ).xyz + sysPtclWorldPos;
#else
    mat4 transposeMat   = transpose( cmpBillboardMat );
    gl_Position.xyz = ( vec4( localPos, 1 ) * cmpBillboardMat ).xyz + sysPtclWorldPos;
#endif
#endif


    //---------------------------------
    // XY ポリゴン
#ifdef _PARTICLE_TYPE_POLYGON_XY
    mat4    tempMat;
    tempMat[0]          = vec4( sysEmitterRT[0].xyz, sysPtclWorldPos.x );
    tempMat[1]          = vec4( sysEmitterRT[1].xyz, sysPtclWorldPos.y );
    tempMat[2]          = vec4( sysEmitterRT[2].xyz, sysPtclWorldPos.z );
    tempMat[3]          = vec4( 0.0, 0.0, 0.0, 1.0 );

#ifdef _USE_ROTATE
    gl_Position         = ( sysPtclRotateMatrix * vec4( localPos, 1 ) );
    gl_Position         = gl_Position * tempMat;
#else
    gl_Position         = vec4( localPos, 1 ) * tempMat;
#endif
#endif


    //---------------------------------
    // XZ ポリゴン
#ifdef _PARTICLE_TYPE_POLYGON_XZ
    vec4    yzFlipPos;
    yzFlipPos.xyz       = localPos.xzy;
    yzFlipPos.w         = 1.0;
    yzFlipPos.z         = -yzFlipPos.z;

#ifdef _USE_ROTATE
    gl_Position         = sysPtclRotateMatrix * yzFlipPos;
#else
    gl_Position         = yzFlipPos;
#endif

    mat4    tempMat;
    tempMat[0]          = vec4( sysEmitterRT[0].xyz, sysPtclWorldPos.x );
    tempMat[1]          = vec4( sysEmitterRT[1].xyz, sysPtclWorldPos.y );
    tempMat[2]          = vec4( sysEmitterRT[2].xyz, sysPtclWorldPos.z );
    tempMat[3]          = vec4( 0.0, 0.0, 0.0, 1.0 );
    gl_Position         = gl_Position * tempMat;
#endif


    vec3 emitterUp;
    vec3 basisX;
    vec3 basisY;
    vec3 basisZ;


    //---------------------------------
    // ディレクショナルビルボード
#ifdef _PARTICLE_TYPE_VEL_LOOK
    emitterUp = -sysEyeVector.xyz;

    mat4 matVelLook = mat4( 1.0, 0.0, 0.0, 0.0,
                            0.0, 1.0, 0.0, 0.0,
                            0.0, 0.0, 1.0, 0.0,
                            0.0, 0.0, 0.0, 1.0 );

    basisY.xyz = sysPtclWorldPosDelta;
    basisY = normalize( basisY );

    basisX = cross( emitterUp, basisY );
    basisX = normalize( basisX );

    basisZ = cross( basisX, basisY );

    matVelLook[0][0] = basisX.x;
    matVelLook[1][0] = basisY.x;
    matVelLook[2][0] = basisZ.x;
    matVelLook[3][0] = 0.0;
    matVelLook[0][1] = basisX.y;
    matVelLook[1][1] = basisY.y;
    matVelLook[2][1] = basisZ.y;
    matVelLook[3][1] = 0.0;
    matVelLook[0][2] = basisX.z;
    matVelLook[1][2] = basisY.z;
    matVelLook[2][2] = basisZ.z;
    matVelLook[3][2] = 0.0;

#ifdef _USE_ROTATE
    matVelLook *= sysPtclRotateMatrix;
#endif

    gl_Position.xyz = ( matVelLook * vec4( localPos, 0 ) ).xyz + sysPtclWorldPos;

#endif


    //---------------------------------
    // ディレクショナルポリゴン
#ifdef _PARTICLE_TYPE_VEL_LOOK_POLYGON
    emitterUp.x      = sysEmitterRT[0].y;
    emitterUp.y      = sysEmitterRT[1].y;
    emitterUp.z      = sysEmitterRT[2].y;

    mat4 matVelLook = mat4( 1.0, 0.0, 0.0, 0.0,
                            0.0, 1.0, 0.0, 0.0,
                            0.0, 0.0, 1.0, 0.0,
                            0.0, 0.0, 0.0, 1.0 );

    basisY.xyz = sysPtclWorldPosDelta;
    basisY = normalize( basisY );

    basisX = cross( emitterUp, basisY );
    basisX = normalize( basisX );

    basisZ = cross( basisX, basisY );

    matVelLook[0][0] = basisX.x;
    matVelLook[1][0] = basisY.x;
    matVelLook[2][0] = basisZ.x;
    matVelLook[3][0] = 0.0;
    matVelLook[0][1] = basisX.y;
    matVelLook[1][1] = basisY.y;
    matVelLook[2][1] = basisZ.y;
    matVelLook[3][1] = 0.0;
    matVelLook[0][2] = basisX.z;
    matVelLook[1][2] = basisY.z;
    matVelLook[2][2] = basisZ.z;
    matVelLook[3][2] = 0.0;

#ifdef _USE_ROTATE
    matVelLook *= sysPtclRotateMatrix;
#endif

    gl_Position.xyz = ( matVelLook * vec4( localPos, 0 ) ).xyz + sysPtclWorldPos;



#endif

    gl_Position.w   = 1.0;

    // スクリーン座標系へ変換
    gl_Position = gl_Position * sysViewProjctionMatrix;

    //-----------------------------------------------------------------
    // テクスチャ座標
#ifdef _PRIMITIVE

#ifdef _TEXTURE0_ENABLE
    sysTexCoord01Vary.x = ( sysTexCoordAttr.x * tex0PatternParam.z ) + tex0ScrollAddX * sysPtclTime;
    sysTexCoord01Vary.y = ( sysTexCoordAttr.y * tex0PatternParam.w ) + tex0ScrollAddY * sysPtclTime;
#endif
#ifdef _TEXTURE1_ENABLE
    sysTexCoord01Vary.z = ( sysTexCoordAttr.x * tex1PatternParam.z ) + tex1ScrollAddX * sysPtclTime;
    sysTexCoord01Vary.w = ( sysTexCoordAttr.y * tex1PatternParam.w ) + tex1ScrollAddY * sysPtclTime;
#endif
#ifdef _TEXTURE2_ENABLE
    sysTexCoord2Vary.x  = sysTexCoordAttr.x;
    sysTexCoord2Vary.y  = sysTexCoordAttr.y;
#endif
#else

    //---------------------------------
    // テクスチャ０のパタン・座標アニメ
#ifdef _TEXTURE0_ENABLE
    float   index        = ( sysInitRotateAttr.w - floor( sysInitRotateAttr.w ) ) *100.0;
    float   uvDivX       = tex0PatternParam.x;
    float   uvDivY       = tex0PatternParam.y;
    float   uvScaleBaseX = tex0PatternParam.z;
    float   uvScaleBaseY = tex0PatternParam.w;

    // 分割後の表示位置
    float indexX = mod( index, tex0PatternParam.x );
    float indexY = index / tex0PatternParam.x;

    indexX = floor( indexX );
    indexY = floor( indexY );

    // UVスケール
    float uScale = uvScaleBaseX * ( 1.0/uvDivX );
    float vScale = uvScaleBaseY * ( 1.0/uvDivY );

    float scrX  = tex0ScrollAddX * sysPtclTime + indexX * uScale;
    float scrY  = tex0ScrollAddY * sysPtclTime - indexY * vScale;
    float rot  = tex0RotateAdd * sysPtclTime;
    float sclX = 1.0 + tex0ScaleAddX * sysPtclTime;
    float sclY = sclX;

    float sinZ = sin( -rot );
    float cosZ = cos( -rot );

    float texu = sysPosAttr.x * cosZ - sysPosAttr.y * sinZ;
    float texv = sysPosAttr.x * sinZ + sysPosAttr.y * cosZ;
    sysTexCoord01Vary.x = ( texu + 0.5 ) *  uScale + scrX - ( 1.0 - sclX ) * texu;
    sysTexCoord01Vary.y = ( texv - 0.5 ) * -vScale - scrY + ( 1.0 - sclY ) * texv;
#endif

    //---------------------------------
    // テクスチャ１のパタン・座標アニメ
#ifdef _TEXTURE1_ENABLE
    index        = floor( sysInitRotateAttr.w );
    uvDivX       = tex1PatternParam.x;
    uvDivY       = tex1PatternParam.y;
    uvScaleBaseX = tex1PatternParam.z;
    uvScaleBaseY = tex1PatternParam.w;

    // 分割後の表示位置
    indexX = mod( index, tex1PatternParam.x );
    indexY = index / tex1PatternParam.x;

    // UVスケール
    uScale = uvScaleBaseX * ( 1.0/uvDivX );
    vScale = uvScaleBaseY * ( 1.0/uvDivY );

    scrX  = tex1ScrollAddX * sysPtclTime + indexX * uScale;
    scrY  = tex1ScrollAddY * sysPtclTime - indexY * vScale;
    rot  = tex1RotateAdd * sysPtclTime;
    sclX = 1.0 + tex1ScaleAddX * sysPtclTime;
    sclY = sclX;

    sinZ = sin( -rot );
    cosZ = cos( -rot );

    texu = sysPosAttr.x * cosZ - sysPosAttr.y * sinZ;
    texv = sysPosAttr.x * sinZ + sysPosAttr.y * cosZ;
    sysTexCoord01Vary.z = ( texu + 0.5 ) *  uScale + scrX - ( 1.0 - sclX ) * texu;
    sysTexCoord01Vary.w = ( texv - 0.5 ) * -vScale - scrY + ( 1.0 - sclY ) * texv;
#endif

    //-------------------------------------------------
    // テクスチャ２はアニメ未対応
#ifdef _TEXTURE2_ENABLE
    sysTexCoord2Vary.x  = sysPosAttr.x + 0.5;
    sysTexCoord2Vary.y  = sysPosAttr.y - 0.5;
#endif
#endif  // _PRIMITIVE


    sysFlagParamVary.x = sysEmitterFadeAlpha;
}
#endif

