﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Xml.Serialization;

using EffectMaker.Foundation.Serialization;

namespace EffectMaker.DataModel.DataModels
{
    /// <summary>
    /// ワークスペースノードデータのベースクラスです。
    /// </summary>
    [Serializable]
    public abstract class WorkspaceNodeDataBase : DataModelBase
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public WorkspaceNodeDataBase() :
            base()
        {
            this.EnableConvert = true;
        }

        /// <summary>
        /// ノードデータをバイナリにコンバートするかどうか取得または設定します。
        /// </summary>
        public bool EnableConvert { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as WorkspaceNodeDataBase;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableConvert = srcDataModel.EnableConvert;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableConvert", this.EnableConvert);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableConvert = this.ReadElement(context, "EnableConvert", this.EnableConvert);

            // This class has nothing to serialize.
            return base.ReadXml(context);
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as WorkspaceNodeDataBase;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EnableConvert = srcDataModel.EnableConvert;

            return true;
        }
    }
}
