﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.RandomColor;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/カラータブ/カラー・アルファ設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterColorSettingsData : DataModelBase
    {
        /// <summary>
        /// カラー0の値を取得または設定します。
        /// </summary>
        private ColorRgba color0Value = null;

        /// <summary>
        /// カラー1の値を取得または設定します。
        /// </summary>
        private ColorRgba color1Value = null;

        /// <summary>
        /// カラー0のアニメーションデータを取得または設定します。
        /// </summary>
        private AnimationTableData colorAnimation0 = null;

        /// <summary>
        /// カラー1のアニメーションデータを取得または設定します。
        /// </summary>
        private AnimationTableData colorAnimation1 = null;

        /// <summary>
        /// アルファ0のアニメーションデータを取得または設定します。
        /// </summary>
        private AnimationTableData alphaAnimation0 = null;

        /// <summary>
        /// アルファ1のアニメーションデータを取得または設定します。
        /// </summary>
        private AnimationTableData alphaAnimation1 = null;

        /// <summary>
        /// カラー0のアニメーション設定データを取得または設定します。
        /// </summary>
        private EmitterColorSettingsAnimationData colorAnimationLoopData0 = null;

        /// <summary>
        /// カラー1のアニメーション設定データを取得または設定します。
        /// </summary>
        private EmitterColorSettingsAnimationData colorAnimationLoopData1 = null;

        /// <summary>
        /// アルファ0のアニメーション設定データを取得または設定します。
        /// </summary>
        private EmitterColorSettingsAnimationData alphaAnimationLoopData0 = null;

        /// <summary>
        /// アルファ1のアニメーション設定データを取得または設定します。
        /// </summary>
        private EmitterColorSettingsAnimationData alphaAnimationLoopData1 = null;

        /// <summary>
        /// カラー0ランダムの値を取得または設定します。
        /// </summary>
        private RandomColorTable randomColor0 = null;

        /// <summary>
        /// カラー1ランダムの値を取得または設定します。
        /// </summary>
        private RandomColorTable randomColor1 = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorSettingsData() :
            base()
        {
            this.Color0BehaviorType = 0;
            this.Color1BehaviorType = 0;
            this.Alpha0BehaviorType = 0;
            this.Alpha1BehaviorType = 0;
            this.Color0Value = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);
            this.Color1Value = new ColorRgba(0.0f, 0.0f, 0.0f, 1.0f);
            this.Alpha0Value = 1.0f;
            this.Alpha1Value = 1.0f;
            this.ColorAnimation0 = new AnimationTableData(0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.ColorAnimation1 = new AnimationTableData(0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.AlphaAnimation0 = new AnimationTableData(0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.AlphaAnimation1 = new AnimationTableData(0, 1.0f, 1.0f, 1.0f, 1.0f);

            this.PostConstruct();
        }

        /// <summary>
        /// カラー0挙動タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3044c1e9-782d-4fa2-aa98-ffb8cc3c656f")]
        public int Color0BehaviorType { get; set; }

        /// <summary>
        /// カラー1挙動タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("47c9193c-6eb9-4aa9-9cec-eec7b8382e2b")]
        public int Color1BehaviorType { get; set; }

        /// <summary>
        /// アルファ0挙動タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b39effb8-2f0a-4e8e-b4ec-a470c69a0744")]
        public int Alpha0BehaviorType { get; set; }

        /// <summary>
        /// アルファ1挙動タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f12811ab-1b1b-4098-a12a-eaa9cd995abf")]
        public int Alpha1BehaviorType { get; set; }

        /// <summary>
        /// カラー0の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ed2c40c6-bb31-4913-8f94-0a05a7544990")]
        public ColorRgba Color0Value
        {
            get { return this.GetObjectFromField(ref this.color0Value, false); }
            set { this.SetISettableToField(ref this.color0Value, value); }
        }

        /// <summary>
        /// カラー1の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("bc97b7bd-9974-4d96-866f-809a4f20d09e")]
        public ColorRgba Color1Value
        {
            get { return this.GetObjectFromField(ref this.color1Value, false); }
            set { this.SetISettableToField(ref this.color1Value, value); }
        }

        /// <summary>
        /// アルファ0の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("908ade7c-5a25-4aec-8831-ba766363ec3e")]
        public float Alpha0Value { get; set; }

        /// <summary>
        /// アルファ1の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0033ef5f-a0cd-46b6-a88a-089958aa718e")]
        public float Alpha1Value { get; set; }

        /// <summary>
        /// カラー0のアニメーションデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c3ec057b-ef8d-44f9-9675-3b5383bb6acd")]
        public AnimationTableData ColorAnimation0
        {
            get { return this.GetObjectFromField(ref this.colorAnimation0, false); }
            set { this.SetISettableToField(ref this.colorAnimation0, value); }
        }

        /// <summary>
        /// カラー1のアニメーションデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0c155e74-73f4-46ba-aca7-0af4ef27320d")]
        public AnimationTableData ColorAnimation1
        {
            get { return this.GetObjectFromField(ref this.colorAnimation1, false); }
            set { this.SetISettableToField(ref this.colorAnimation1, value); }
        }

        /// <summary>
        /// アルファ0のアニメーションデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("af62b763-00ec-4582-bbf3-99b06aacef10")]
        public AnimationTableData AlphaAnimation0
        {
            get { return this.GetObjectFromField(ref this.alphaAnimation0, false); }
            set { this.SetISettableToField(ref this.alphaAnimation0, value); }
        }

        /// <summary>
        /// アルファ1のアニメーションデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6d8a08e1-9624-48d3-b78e-27f95989a442")]
        public AnimationTableData AlphaAnimation1
        {
            get { return this.GetObjectFromField(ref this.alphaAnimation1, false); }
            set { this.SetISettableToField(ref this.alphaAnimation1, value); }
        }

        /// <summary>
        /// カラー0のアニメーション設定データを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f601cb40-58e8-42b8-b355-c1a10836ed16")]
        public EmitterColorSettingsAnimationData ColorAnimationLoopData0
        {
            get { return this.GetDataModelFromField(ref this.colorAnimationLoopData0, false); }
            set { this.SetDataModelToField(ref this.colorAnimationLoopData0, value); }
        }

        /// <summary>
        /// カラー1のアニメーション設定データを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e925f436-10c0-409e-9e11-8a2439d345cd")]
        public EmitterColorSettingsAnimationData ColorAnimationLoopData1
        {
            get { return this.GetDataModelFromField(ref this.colorAnimationLoopData1, false); }
            set { this.SetDataModelToField(ref this.colorAnimationLoopData1, value); }
        }

        /// <summary>
        /// アルファ0のアニメーション設定データを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("db2902a2-a34b-4979-bb03-ef18d8c1312b")]
        public EmitterColorSettingsAnimationData AlphaAnimationLoopData0
        {
            get { return this.GetDataModelFromField(ref this.alphaAnimationLoopData0, false); }
            set { this.SetDataModelToField(ref this.alphaAnimationLoopData0, value); }
        }

        /// <summary>
        /// アルファ1のアニメーション設定データを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d15e8893-d0b7-4b1c-a876-0ef0a56a9e1a")]
        public EmitterColorSettingsAnimationData AlphaAnimationLoopData1
        {
            get { return this.GetDataModelFromField(ref this.alphaAnimationLoopData1, false); }
            set { this.SetDataModelToField(ref this.alphaAnimationLoopData1, value); }
        }

        /// <summary>
        /// カラー0ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("92953cca-f2d8-4289-97e6-23646e681827")]
        public RandomColorTable RandomColor0
        {
            get { return this.GetObjectFromField(ref this.randomColor0, false); }
            set { this.SetISettableToField(ref this.randomColor0, value); }
        }

        /// <summary>
        /// カラー1ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3bb877f8-9a60-4a72-af14-ccb8abac1cbf")]
        public RandomColorTable RandomColor1
        {
            get { return this.GetObjectFromField(ref this.randomColor1, false); }
            set { this.SetISettableToField(ref this.randomColor1, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterColorSettingsData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Color0BehaviorType = srcDataModel.Color0BehaviorType;
            this.Color1BehaviorType = srcDataModel.Color1BehaviorType;
            this.Alpha0BehaviorType = srcDataModel.Alpha0BehaviorType;
            this.Alpha1BehaviorType = srcDataModel.Alpha1BehaviorType;
            this.Color0Value = srcDataModel.Color0Value;
            this.Color1Value = srcDataModel.Color1Value;
            this.Alpha0Value = srcDataModel.Alpha0Value;
            this.Alpha1Value = srcDataModel.Alpha1Value;
            this.ColorAnimation0 = srcDataModel.ColorAnimation0;
            this.ColorAnimation1 = srcDataModel.ColorAnimation1;
            this.AlphaAnimation0 = srcDataModel.AlphaAnimation0;
            this.AlphaAnimation1 = srcDataModel.AlphaAnimation1;
            this.ColorAnimationLoopData0 = srcDataModel.ColorAnimationLoopData0;
            this.ColorAnimationLoopData1 = srcDataModel.ColorAnimationLoopData1;
            this.AlphaAnimationLoopData0 = srcDataModel.AlphaAnimationLoopData0;
            this.AlphaAnimationLoopData1 = srcDataModel.AlphaAnimationLoopData1;
            this.RandomColor0 = srcDataModel.RandomColor0;
            this.RandomColor1 = srcDataModel.RandomColor1;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Color0BehaviorType", this.Color0BehaviorType);
            this.WriteElement(context, "Color1BehaviorType", this.Color1BehaviorType);
            this.WriteElement(context, "Alpha0BehaviorType", this.Alpha0BehaviorType);
            this.WriteElement(context, "Alpha1BehaviorType", this.Alpha1BehaviorType);
            this.WriteElement(context, "Color0Value", this.Color0Value);
            this.WriteElement(context, "Color1Value", this.Color1Value);
            this.WriteElement(context, "Alpha0Value", this.Alpha0Value);
            this.WriteElement(context, "Alpha1Value", this.Alpha1Value);
            this.WriteElement(context, "ColorAnimation0", this.ColorAnimation0);
            this.WriteElement(context, "ColorAnimation1", this.ColorAnimation1);
            this.WriteElement(context, "AlphaAnimation0", this.AlphaAnimation0);
            this.WriteElement(context, "AlphaAnimation1", this.AlphaAnimation1);
            this.WriteElement(context, "ColorAnimationLoopData0", this.ColorAnimationLoopData0);
            this.WriteElement(context, "ColorAnimationLoopData1", this.ColorAnimationLoopData1);
            this.WriteElement(context, "AlphaAnimationLoopData0", this.AlphaAnimationLoopData0);
            this.WriteElement(context, "AlphaAnimationLoopData1", this.AlphaAnimationLoopData1);
            this.WriteElement(context, "RandomColor0", this.RandomColor0);
            this.WriteElement(context, "RandomColor1", this.RandomColor1);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Color0BehaviorType = this.ReadElement(context, "Color0BehaviorType", this.Color0BehaviorType);
            this.Color1BehaviorType = this.ReadElement(context, "Color1BehaviorType", this.Color1BehaviorType);
            this.Alpha0BehaviorType = this.ReadElement(context, "Alpha0BehaviorType", this.Alpha0BehaviorType);
            this.Alpha1BehaviorType = this.ReadElement(context, "Alpha1BehaviorType", this.Alpha1BehaviorType);
            this.Color0Value = this.ReadElement(context, "Color0Value", this.Color0Value);
            this.Color1Value = this.ReadElement(context, "Color1Value", this.Color1Value);
            this.Alpha0Value = this.ReadElement(context, "Alpha0Value", this.Alpha0Value);
            this.Alpha1Value = this.ReadElement(context, "Alpha1Value", this.Alpha1Value);
            this.ColorAnimation0 = this.ReadElement(context, "ColorAnimation0", this.ColorAnimation0);
            this.ColorAnimation1 = this.ReadElement(context, "ColorAnimation1", this.ColorAnimation1);
            this.AlphaAnimation0 = this.ReadElement(context, "AlphaAnimation0", this.AlphaAnimation0);
            this.AlphaAnimation1 = this.ReadElement(context, "AlphaAnimation1", this.AlphaAnimation1);
            this.ColorAnimationLoopData0 = this.ReadElement(context, "ColorAnimationLoopData0", this.ColorAnimationLoopData0);
            this.ColorAnimationLoopData1 = this.ReadElement(context, "ColorAnimationLoopData1", this.ColorAnimationLoopData1);
            this.AlphaAnimationLoopData0 = this.ReadElement(context, "AlphaAnimationLoopData0", this.AlphaAnimationLoopData0);
            this.AlphaAnimationLoopData1 = this.ReadElement(context, "AlphaAnimationLoopData1", this.AlphaAnimationLoopData1);
            this.RandomColor0 = this.ReadElement(context, "RandomColor0", this.RandomColor0);
            this.RandomColor1 = this.ReadElement(context, "RandomColor1", this.RandomColor1);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterColorSettingsData(PrevVersion.EmitterColorSettingsData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterColorSettingsData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterColorSettingsData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Color0BehaviorType = srcDataModel.Color0BehaviorType;
            this.Color1BehaviorType = srcDataModel.Color1BehaviorType;
            this.Alpha0BehaviorType = srcDataModel.Alpha0BehaviorType;
            this.Alpha1BehaviorType = srcDataModel.Alpha1BehaviorType;
            this.Color0Value = srcDataModel.Color0Value;
            this.Color1Value = srcDataModel.Color1Value;
            this.Alpha0Value = srcDataModel.Alpha0Value;
            this.Alpha1Value = srcDataModel.Alpha1Value;
            this.ColorAnimation0 = srcDataModel.ColorAnimation0;
            this.ColorAnimation1 = srcDataModel.ColorAnimation1;
            this.AlphaAnimation0 = srcDataModel.AlphaAnimation0;
            this.AlphaAnimation1 = srcDataModel.AlphaAnimation1;
            this.ColorAnimationLoopData0 = srcDataModel.ColorAnimationLoopData0;
            this.ColorAnimationLoopData1 = srcDataModel.ColorAnimationLoopData1;
            this.AlphaAnimationLoopData0 = srcDataModel.AlphaAnimationLoopData0;
            this.AlphaAnimationLoopData1 = srcDataModel.AlphaAnimationLoopData1;
            this.RandomColor0 = srcDataModel.RandomColor0;
            this.RandomColor1 = srcDataModel.RandomColor1;

            return true;
        }
    }
}
