﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/コンバイナタブ/シェーダコンバイナツールグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterCombinerEditorData : DataModelBase
    {
        /// <summary>
        /// コンバイナシェーダ係数アニメのアニメーションデータを取得または設定します。
        /// </summary>
        private EmitterCombinerEditorAnimationCurveData emitterCombinerEditorAnimationCurveData0 = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCombinerEditorData() :
            base()
        {
            this.CombinerEditorProjectPath = string.Empty;

            this.PostConstruct();
        }

        /// <summary>
        /// プロジェクトファイルのパスを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c07be36b-2ce7-4ab5-b66d-bbfb169e6b45")]
        public string CombinerEditorProjectPath { get; set; }

        /// <summary>
        /// コンバイナシェーダ係数アニメのアニメーションデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("512db20f-52dd-4a3f-947e-c19537206d92")]
        public EmitterCombinerEditorAnimationCurveData EmitterCombinerEditorAnimationCurveData0
        {
            get { return this.GetDataModelFromField(ref this.emitterCombinerEditorAnimationCurveData0, false); }
            set { this.SetDataModelToField(ref this.emitterCombinerEditorAnimationCurveData0, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterCombinerEditorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.CombinerEditorProjectPath = srcDataModel.CombinerEditorProjectPath;
            this.EmitterCombinerEditorAnimationCurveData0 = srcDataModel.EmitterCombinerEditorAnimationCurveData0;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "CombinerEditorProjectPath", this.CombinerEditorProjectPath);
            this.WriteElement(context, "EmitterCombinerEditorAnimationCurveData0", this.EmitterCombinerEditorAnimationCurveData0);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.CombinerEditorProjectPath = this.ReadElement(context, "CombinerEditorProjectPath", this.CombinerEditorProjectPath);
            this.EmitterCombinerEditorAnimationCurveData0 = this.ReadElement(context, "EmitterCombinerEditorAnimationCurveData0", this.EmitterCombinerEditorAnimationCurveData0);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterCombinerEditorData(PrevVersion.EmitterCombinerEditorData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterCombinerEditorData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterCombinerEditorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.CombinerEditorProjectPath = srcDataModel.CombinerEditorProjectPath;
            this.EmitterCombinerEditorAnimationCurveData0 = srcDataModel.EmitterCombinerEditorAnimationCurveData0;

            return true;
        }
    }
}
