﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Collections.Generic;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_2;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/テクスチャタブ/テクスチャパターンアニメグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterTexturePatternAnimationData : DataModelBase
    {
        /// <summary>
        /// パターンテーブルを取得または設定します。
        /// </summary>
        private ArrayCollection<int> patternTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTexturePatternAnimationData() :
            base()
        {
            this.PatternAnimType = 0;
            this.DurationCountPerFrame = 1;
            this.PatternTableCount = 2;
            this.RandomPatternTableCount = 1;
            this.EnableSimpleTableRandom = false;
            this.SimpleTableInput = string.Empty;

            this.PostConstruct();
        }

        /// <summary>
        /// 再生方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("dabd4b10-4cd5-4a0b-bc00-ee99e2aa5ff1")]
        public int PatternAnimType { get; set; }

        /// <summary>
        /// 1コマの継続フレーム数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("795849ff-cffc-4a89-8be0-bdc45a02dbc0")]
        public int DurationCountPerFrame { get; set; }

        /// <summary>
        /// 使用パターンテーブル数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a01a612a-d8e9-4adf-a82a-04d2c33a4e50")]
        public int PatternTableCount { get; set; }

        /// <summary>
        /// ランダムのパターン数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("18503eae-62fc-4a60-aa1e-4d81f561ea17")]
        public int RandomPatternTableCount { get; set; }

        /// <summary>
        /// 開始テーブルランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("447492e2-2562-421b-8e4a-f38e05c90476")]
        public bool EnableSimpleTableRandom { get; set; }

        /// <summary>
        /// テーブル簡易入力の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2f2c4f16-19ee-4438-8df8-34bb5fd72591")]
        public string SimpleTableInput { get; set; }

        /// <summary>
        /// パターンテーブルを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("36352cd0-4606-4234-81ec-258f0adb9ab8")]
        public ArrayCollection<int> PatternTable
        {
            get
            {
                if (this.patternTable == null)
                {
                    this.patternTable = new ArrayCollection<int>(32);
                }

                return this.patternTable.Clone() as ArrayCollection<int>;
            }

            set
            {
                if (this.patternTable == null)
                {
                    this.patternTable = new ArrayCollection<int>(32);
                }

                this.patternTable.Set(value);
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterTexturePatternAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.PatternAnimType = srcDataModel.PatternAnimType;
            this.DurationCountPerFrame = srcDataModel.DurationCountPerFrame;
            this.PatternTableCount = srcDataModel.PatternTableCount;
            this.RandomPatternTableCount = srcDataModel.RandomPatternTableCount;
            this.EnableSimpleTableRandom = srcDataModel.EnableSimpleTableRandom;
            this.SimpleTableInput = srcDataModel.SimpleTableInput;
            this.PatternTable = srcDataModel.PatternTable;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "PatternAnimType", this.PatternAnimType);
            this.WriteElement(context, "DurationCountPerFrame", this.DurationCountPerFrame);
            this.WriteElement(context, "PatternTableCount", this.PatternTableCount);
            this.WriteElement(context, "RandomPatternTableCount", this.RandomPatternTableCount);
            this.WriteElement(context, "EnableSimpleTableRandom", this.EnableSimpleTableRandom);
            this.WriteElement(context, "SimpleTableInput", this.SimpleTableInput);
            this.WriteElement(context, "PatternTable", this.PatternTable);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.PatternAnimType = this.ReadElement(context, "PatternAnimType", this.PatternAnimType);
            this.DurationCountPerFrame = this.ReadElement(context, "DurationCountPerFrame", this.DurationCountPerFrame);
            this.PatternTableCount = this.ReadElement(context, "PatternTableCount", this.PatternTableCount);
            this.RandomPatternTableCount = this.ReadElement(context, "RandomPatternTableCount", this.RandomPatternTableCount);
            this.EnableSimpleTableRandom = this.ReadElement(context, "EnableSimpleTableRandom", this.EnableSimpleTableRandom);
            this.SimpleTableInput = this.ReadElement(context, "SimpleTableInput", this.SimpleTableInput);
            this.PatternTable = this.ReadElement(context, "PatternTable", this.PatternTable);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterTexturePatternAnimationData(PrevVersion.EmitterTexturePatternAnimationData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterTexturePatternAnimationData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterTexturePatternAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.PatternAnimType = srcDataModel.PatternAnimType;
            this.DurationCountPerFrame = srcDataModel.DurationCountPerFrame;
            this.PatternTableCount = srcDataModel.PatternTableCount;
            this.RandomPatternTableCount = srcDataModel.RandomPatternTableCount;
            this.EnableSimpleTableRandom = srcDataModel.EnableSimpleTableRandom;
            this.SimpleTableInput = srcDataModel.SimpleTableInput;
            this.PatternTable = srcDataModel.PatternTable;

            return true;
        }
    }
}
