﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタセットノード/ユーザーデータタブデータ.
    /// </summary>
    [Serializable]
    public class EmitterSetUserData : DataModelBase
    {
        /// <summary>
        /// ビットグループデータを取得または設定します。
        /// </summary>
        private EmitterSetUserFlagData emitterSetUserFlagData = null;

        /// <summary>
        /// 数値グループデータを取得または設定します。
        /// </summary>
        private EmitterSetUserValueData emitterSetUserValueData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterSetUserData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// ビットグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7415edcd-64e4-404a-bf2e-cdfdf6dfc787")]
        public EmitterSetUserFlagData EmitterSetUserFlagData
        {
            get { return this.GetDataModelFromField(ref this.emitterSetUserFlagData, false); }
            set { this.SetDataModelToField(ref this.emitterSetUserFlagData, value); }
        }

        /// <summary>
        /// 数値グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("add43ddc-f814-4579-ba1b-1de66603dbbd")]
        public EmitterSetUserValueData EmitterSetUserValueData
        {
            get { return this.GetDataModelFromField(ref this.emitterSetUserValueData, false); }
            set { this.SetDataModelToField(ref this.emitterSetUserValueData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterSetUserData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterSetUserFlagData = srcDataModel.EmitterSetUserFlagData;
            this.EmitterSetUserValueData = srcDataModel.EmitterSetUserValueData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterSetUserFlagData", this.EmitterSetUserFlagData);
            this.WriteElement(context, "EmitterSetUserValueData", this.EmitterSetUserValueData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterSetUserFlagData = this.ReadElement(context, "EmitterSetUserFlagData", this.EmitterSetUserFlagData);
            this.EmitterSetUserValueData = this.ReadElement(context, "EmitterSetUserValueData", this.EmitterSetUserValueData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterSetUserData(PrevVersion.EmitterSetUserData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterSetUserData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterSetUserData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterSetUserFlagData = srcDataModel.EmitterSetUserFlagData;
            this.EmitterSetUserValueData = srcDataModel.EmitterSetUserValueData;

            return true;
        }
    }
}
