﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Reflection;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カラー.
    /// </summary>
    [Serializable]
    public class PreviewColorData : DataModelBase
    {
        /// <summary>
        /// カラー(EmitterSet::SetAlpha/SetColor).
        /// </summary>
        private ColorRgba color = null;

        /// <summary>
        /// エミッタカラー0
        /// </summary>
        private ColorRgba emitterColor0 = null;

        /// <summary>
        /// エミッタカラー1
        /// </summary>
        private ColorRgba emitterColor1 = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewColorData() :
            base()
        {
            this.Color = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);
            this.EnableEmitterColor = false;
            this.EmitterColor0 = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);
            this.EmitterColor1 = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);

            this.PostConstruct();
        }

        /// <summary>
        /// カラー(EmitterSet::SetAlpha/SetColor).
        /// </summary>
        [DataModelPropertyGuid("21a63b0f-9d62-4e47-9181-103e2444ddc7")]
        public ColorRgba Color
        {
            get { return this.GetObjectFromField(ref this.color, false); }
            set { this.SetISettableToField(ref this.color, value); }
        }

        /// <summary>
        /// エミッタカラーに対する乗算
        /// </summary>
        [DataModelPropertyGuid("74d5eed4-9520-4152-8fac-2741a603dfe6")]
        public bool EnableEmitterColor { get; set; }

        /// <summary>
        /// エミッタカラー0
        /// </summary>
        [DataModelPropertyGuid("1ba8dfab-665c-4a91-9a9e-687fa8403db5")]
        public ColorRgba EmitterColor0
        {
            get { return this.GetObjectFromField(ref this.emitterColor0, false); }
            set { this.SetISettableToField(ref this.emitterColor0, value); }
        }

        /// <summary>
        /// エミッタカラー1
        /// </summary>
        [DataModelPropertyGuid("23afecf9-373a-4d20-b47b-a815d52714ce")]
        public ColorRgba EmitterColor1
        {
            get { return this.GetObjectFromField(ref this.emitterColor1, false); }
            set { this.SetISettableToField(ref this.emitterColor1, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewColorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Color = srcDataModel.Color;
            this.EnableEmitterColor = srcDataModel.EnableEmitterColor;
            this.EmitterColor0 = srcDataModel.EmitterColor0;
            this.EmitterColor1 = srcDataModel.EmitterColor1;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Color", this.Color);
            this.WriteElement(context, "EnableEmitterColor", this.EnableEmitterColor);
            this.WriteElement(context, "EmitterColor0", this.EmitterColor0);
            this.WriteElement(context, "EmitterColor1", this.EmitterColor1);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Color = this.ReadElement(context, "Color", this.Color);
            this.EnableEmitterColor = this.ReadElement(context, "EnableEmitterColor", this.EnableEmitterColor);
            this.EmitterColor0 = this.ReadElement(context, "EmitterColor0", this.EmitterColor0);
            this.EmitterColor1 = this.ReadElement(context, "EmitterColor1", this.EmitterColor1);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewColorData(PrevVersion.PreviewColorData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewColorData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewColorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Color = srcDataModel.Color;
            this.EnableEmitterColor = srcDataModel.EnableEmitterColor;
            this.EmitterColor0 = srcDataModel.EmitterColor0;
            this.EmitterColor1 = srcDataModel.EmitterColor1;

            return true;
        }
    }
}
