﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/収束タブ/収束グループデータです。
    /// </summary>
    [Serializable]
    public class ConvergeParamData : DataModelBase
    {
        /// <summary>
        /// 位置を取得または設定します。
        /// </summary>
        private Vector3f position = null;

        /// <summary>
        /// 収束力のパーティクル時間アニメを取得または設定します。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ConvergeParamData() :
            base()
        {
            this.Ratio = 0.0f;
            this.Position = new Vector3f(0.0f, 0.0f, 0.0f);
            this.FollowEmitter = false;
            this.EnableAnimation = 0;
            this.AnimationTable = new AnimationTableData(new AnimationTableData(0, 0.0f, 0.0f, 0.0f, 0.0f));
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// 収束力を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1d200814-797d-44e1-bb8e-f3e62ac11ce3")]
        public float Ratio { get; set; }

        /// <summary>
        /// 位置を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7934cf1b-729d-416a-9a28-eaa507c5bf36")]
        public Vector3f Position
        {
            get { return this.GetObjectFromField(ref this.position, false); }
            set { this.SetISettableToField(ref this.position, value); }
        }

        /// <summary>
        /// 位置をエミッタに追従のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b7516a69-7a5c-44d8-a6f1-ede119b91c1c")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// 収束力のパーティクル時間アニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("671e8d10-91fb-42fc-b053-740deaef6a2e")]
        public int EnableAnimation { get; set; }

        /// <summary>
        /// 収束力のパーティクル時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("212a8b4c-28b9-40be-a597-f487115a5a16")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// 収束力のパーティクル時間アニメについて再生方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("710eff85-5219-4bd9-b445-ab573f2a48c3")]
        public int LoopMode { get; set; }

        /// <summary>
        /// 収束力のパーティクル時間アニメについて終端フレームを取得または設定します。
        /// 再生方法をループ再生にしたとき使用します。
        /// </summary>
        [DataModelPropertyGuid("ea2268ca-f62b-4d8b-b725-881f050f05e2")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 収束力のエミッタ時間アニメについて開始位置のランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c34ac6fa-46ff-49d0-8bf8-d33c884e3753")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ConvergeParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Ratio = srcDataModel.Ratio;
            this.Position = srcDataModel.Position;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Ratio", this.Ratio);
            this.WriteElement(context, "Position", this.Position);
            this.WriteElement(context, "FollowEmitter", this.FollowEmitter);
            this.WriteElement(context, "EnableAnimation", this.EnableAnimation);
            this.WriteElement(context, "AnimationTable", this.AnimationTable);
            this.WriteElement(context, "LoopMode", this.LoopMode);
            this.WriteElement(context, "LoopEnd", this.LoopEnd);
            this.WriteElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Ratio = this.ReadElement(context, "Ratio", this.Ratio);
            this.Position = this.ReadElement(context, "Position", this.Position);
            this.FollowEmitter = this.ReadElement(context, "FollowEmitter", this.FollowEmitter);
            this.EnableAnimation = this.ReadElement(context, "EnableAnimation", this.EnableAnimation);
            this.AnimationTable = this.ReadElement(context, "AnimationTable", this.AnimationTable);
            this.LoopMode = this.ReadElement(context, "LoopMode", this.LoopMode);
            this.LoopEnd = this.ReadElement(context, "LoopEnd", this.LoopEnd);
            this.Randomize = this.ReadElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ConvergeParamData(PrevVersion.ConvergeParamData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ConvergeParamData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ConvergeParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Ratio = srcDataModel.Ratio;
            this.Position = srcDataModel.Position;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }
    }
}
