﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.ObjectModel;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// オフセット行列データ.
    /// </summary>
    [Serializable]
    public class PreviewMatrixOffsetMatrixData : DataModelBase
    {
        /// <summary>
        /// スケール.
        /// </summary>
        private Vector3f offsetScale = null;

        /// <summary>
        /// 座標.
        /// </summary>
        private Vector3f offsetPosition = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewMatrixOffsetMatrixData() :
            base()
        {
            this.OffsetScale = new Vector3f(1.0f, 1.0f, 1.0f);
            this.EmitterBillboard = false;
            this.OffsetRotationX = 0.0f;
            this.OffsetRotationY = 0.0f;
            this.OffsetRotationZ = 0.0f;
            this.OffsetPosition = new Vector3f(0.0f, 0.0f, 0.0f);

            this.PostConstruct();
        }

        /// <summary>
        /// スケール.
        /// </summary>
        [DataModelPropertyGuid("7d04f4d3-fbe9-464b-9006-94cbe27f3db4")]
        public Vector3f OffsetScale
        {
            get { return this.GetObjectFromField(ref this.offsetScale, false); }
            set { this.SetISettableToField(ref this.offsetScale, value); }
        }

        /// <summary>
        /// エミッタビルボード.
        /// </summary>
        [DataModelPropertyGuid("07a067fd-51f5-4381-832e-df32a173ee71")]
        public bool EmitterBillboard { get; set; }

        /// <summary>
        /// 回転X.
        /// </summary>
        [DataModelPropertyGuid("d63c2ca6-67e8-40cc-b147-37826c659713")]
        public float OffsetRotationX { get; set; }

        /// <summary>
        /// 回転Y.
        /// </summary>
        [DataModelPropertyGuid("0bde001c-f6e3-4e61-b90d-f812b6780e60")]
        public float OffsetRotationY { get; set; }

        /// <summary>
        /// 回転Z
        /// </summary>
        [DataModelPropertyGuid("64ab611e-9094-4b8f-af7a-fece381e4b1e")]
        public float OffsetRotationZ { get; set; }

        /// <summary>
        /// 座標.
        /// </summary>
        [DataModelPropertyGuid("59d7cccb-beaf-4ae2-a0a3-5699d0332d5f")]
        public Vector3f OffsetPosition
        {
            get { return this.GetObjectFromField(ref this.offsetPosition, false); }
            set { this.SetISettableToField(ref this.offsetPosition, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewMatrixOffsetMatrixData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.OffsetScale = srcDataModel.OffsetScale;
            this.EmitterBillboard = srcDataModel.EmitterBillboard;
            this.OffsetRotationX = srcDataModel.OffsetRotationX;
            this.OffsetRotationY = srcDataModel.OffsetRotationY;
            this.OffsetRotationZ = srcDataModel.OffsetRotationZ;
            this.OffsetPosition = srcDataModel.OffsetPosition;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "OffsetScale", this.OffsetScale);
            this.WriteElement(context, "EmitterBillboard", this.EmitterBillboard);
            this.WriteElement(context, "OffsetRotationX", this.OffsetRotationX);
            this.WriteElement(context, "OffsetRotationY", this.OffsetRotationY);
            this.WriteElement(context, "OffsetRotationZ", this.OffsetRotationZ);
            this.WriteElement(context, "OffsetPosition", this.OffsetPosition);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.OffsetScale = this.ReadElement(context, "OffsetScale", this.OffsetScale);
            this.EmitterBillboard = this.ReadElement(context, "EmitterBillboard", this.EmitterBillboard);
            this.OffsetRotationX = this.ReadElement(context, "OffsetRotationX", this.OffsetRotationX);
            this.OffsetRotationY = this.ReadElement(context, "OffsetRotationY", this.OffsetRotationY);
            this.OffsetRotationZ = this.ReadElement(context, "OffsetRotationZ", this.OffsetRotationZ);
            this.OffsetPosition = this.ReadElement(context, "OffsetPosition", this.OffsetPosition);

            return success;
        }
    }
}
