﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// Viewerにモデルバイナリを送るための暫定データです。
    /// </summary>
    [Serializable]
    public class ModelAutoMoveData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelAutoMoveData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("e7058b7a-9f6b-4883-81eb-858e4c3f3621")]
        public int MoveType { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("ee496099-f645-455d-bb79-9da7c09b2f33")]
        public float RadiusXZ { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("8120e96b-6b93-45bd-bb9a-d1a70b3e947b")]
        public float SpeedXZ { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("fe485d1b-d5ff-4db0-83f2-7a54ad49a2bd")]
        public float AmplitudeY { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("bcbc6a8b-dbaa-49ad-b1eb-4b9237720880")]
        public float SpeedY { get; set; }

        /// <summary>
        ///
        /// </summary>
        [DataModelPropertyGuid("c2a78eb4-f52f-4d7a-a548-b6028cc6329e")]
        public float RoolZ { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ModelAutoMoveData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MoveType = srcDataModel.MoveType;
            this.RadiusXZ = srcDataModel.RadiusXZ;
            this.SpeedXZ = srcDataModel.SpeedXZ;
            this.AmplitudeY = srcDataModel.AmplitudeY;
            this.SpeedY = srcDataModel.SpeedY;
            this.RoolZ = srcDataModel.RoolZ;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "MoveType", this.MoveType);
            this.WriteElement(context, "RadiusXZ", this.RadiusXZ);
            this.WriteElement(context, "SpeedXZ", this.SpeedXZ);
            this.WriteElement(context, "AmplitudeY", this.AmplitudeY);
            this.WriteElement(context, "SpeedY", this.SpeedY);
            this.WriteElement(context, "RoolZ", this.RoolZ);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.MoveType = this.ReadElement(context, "MoveType", this.MoveType);
            this.RadiusXZ = this.ReadElement(context, "RadiusXZ", this.RadiusXZ);
            this.SpeedXZ = this.ReadElement(context, "SpeedXZ", this.SpeedXZ);
            this.AmplitudeY = this.ReadElement(context, "AmplitudeY", this.AmplitudeY);
            this.SpeedY = this.ReadElement(context, "SpeedY", this.SpeedY);
            this.RoolZ = this.ReadElement(context, "RoolZ", this.RoolZ);

            return success;
        }
    }
}
