﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.Foundation.Extensions;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// Data model for an array of primitive.
    /// This data model is made for writing binary data.
    /// </summary>
    /// <remarks>
    /// This data model is not generated from the DataModelMaker, do not overwrite it.
    /// </remarks>
    public class ShaderArrayData : DataModelBase
    {
        /// <summary>The list of shader resource data.</summary>
        private List<ShaderResourceData> shaderResourceList = new List<ShaderResourceData>();

        /// <summary>
        /// Constructor.
        /// </summary>
        public ShaderArrayData() :
            base()
        {
        }

        /// <summary>
        /// Get or set the list of primitive resource data.
        /// </summary>
        public IEnumerable<ShaderResourceData> ShaderResources
        {
            get { return this.shaderResourceList; }
        }

        /// <summary>
        /// Add a new shader source code to the shader array, the corresponding
        /// shader resource data and shader binary data will be automatically
        /// created.
        /// </summary>
        /// <param name="shaderType">The shader type.</param>
        /// <param name="shaderCode">The shader code.</param>
        public void AddShader(ShaderTypes shaderType, string shaderCode)
        {
            var shaderRes = new ShaderResourceData()
            {
                Parent = this,
                ShaderCode = shaderCode,
                ShaderType = shaderType,
            };

            this.shaderResourceList.Add(shaderRes);
        }

        /// <summary>
        /// Add a new shader source code to the shader array, the corresponding
        /// shader resource data and shader binary data will be automatically
        /// created.
        /// </summary>
        /// <param name="shaderType">The shader type.</param>
        /// <param name="shaderID">The shader ID.</param>
        /// <param name="shaderCode">The shader source code.</param>
        public void AddCustomShader(
            ShaderTypes shaderType,
            int shaderID,
            string shaderCode)
        {
            var shaderRes = new CustomShaderResourceData()
            {
                Parent = this,
                ShaderCode = shaderCode,
                ShaderID = shaderID,
                ShaderType = shaderType,
            };

            this.shaderResourceList.Add(shaderRes);
        }

        /// <summary>
        /// Set up the data model with the given source object.
        /// </summary>
        /// <param name="src">The source object to set from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as ShaderArrayData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SetDataModelListToField(
                ref this.shaderResourceList,
                srcDataModel.shaderResourceList);

            return true;
        }
    }
}
