﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the SampleDataModel.
    /// </summary>
    public class SampleViewModel : ViewModelBase<SampleDataModel>
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        public SampleViewModel()
            : base(new SampleDataModel())
        {
        }

        /// <summary>
        /// Initializes the SampleViewModel instance.
        /// </summary>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public SampleViewModel(SampleDataModel dataModel)
            : base(dataModel)
        {
        }

        /// <summary>
        /// Get the age of the employee.
        /// </summary>
        public int Age
        {
            get
            {
                return DateTime.Now.Year - this.Proxy.Birthday.Year;
            }
        }
    }
}
