﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UILogic.Properties;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the PreviewBasicFileViewModel.
    /// </summary>
    public class PreviewMatrixOffsetMatrixViewModel : PropertyGroupViewModel<PreviewMatrixOffsetMatrixData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public PreviewMatrixOffsetMatrixViewModel(
            HierarchyViewModel parent, PreviewMatrixOffsetMatrixData dataModel)
            : base(parent, dataModel)
        {
            this.EmitterBillboardTypeItems = new []
            {
                new KeyValuePair<string, object>(Properties.Resources.PreviewMatrixOffsetRotationBillboardTypeNone, 0),
                new KeyValuePair<string, object>(Properties.Resources.PreviewMatrixOffsetRotationBillboardTypeEmitterBillboard, 1),
                new KeyValuePair<string, object>(Properties.Resources.PreviewMatrixOffsetRotationBillboardTypeEmitterBillboardY, 2)
            };

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// エミッタのビルボードのタイプ
        /// </summary>
        public IEnumerable<KeyValuePair<string, object>> EmitterBillboardTypeItems { get; private set; }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
