﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// 読み込み結果と読み込んだテクスチャデータ
    /// </summary>
    public class LoadEmitterSetResultWithData
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="result">読み込み結果</param>
        /// <param name="viewModel">ビューモデル</param>
        public LoadEmitterSetResultWithData(LoadEmitterSetResults result, EmitterSetViewModel viewModel)
        {
            this.Result = result;
            this.ViewModel = viewModel;
        }

        /// <summary>
        /// 読み込み結果
        /// </summary>
        public LoadEmitterSetResults Result { get; set; }

        /// <summary>
        /// ビューモデル
        /// </summary>
        public EmitterSetViewModel ViewModel { get; set; }
    }
}
