﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// 保存可能なビューモデルのインターフェイスです。
    /// </summary>
    interface IFileOwner
    {
        /// <summary>
        /// ファイル名(拡張子を含まない)を取得します。
        /// </summary>
        string FileName
        {
            get;
        }

        /// <summary>
        /// ファイルパス(ファイル名を含まない)を取得します。
        /// </summary>
        string FilePath
        {
            get;
        }
    }
}
