﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// エミッタを保持するビューモデルのインターフェイスです。
    /// </summary>
    public interface IEmitterOwnerViewModel
    {
        /// <summary>
        /// エミッタを作成します。
        /// ビューモデル, データモデル両方の処理を行います。
        /// </summary>
        /// <param name="emitterName">エミッタ名</param>
        /// <param name="presetEmitter">プリセットとなるエミッタデータ(nullなら完全新規作成)</param>
        /// <returns>エミッタビューモデルを返します。</returns>
        EmitterViewModel CreateNewEmitter(string emitterName, EmitterData presetEmitter);

        /// <summary>
        /// エミッタを追加します。
        /// ビューモデル, データモデル両方の処理を行います。
        /// </summary>
        /// <param name="emitterViewModel">エミッタビューモデル</param>
        /// <returns>処理が成功したときtrueを返します。</returns>
        bool AddEmitter(EmitterViewModel emitterViewModel);

        /// <summary>
        /// エミッタを削除します。
        /// ビューモデル, データモデル両方の処理を行います。
        /// </summary>
        /// <param name="emitterViewModel">エミッタビューモデル</param>
        /// <returns>処理が成功したときtrueを返します。</returns>
        bool RemoveEmitter(EmitterViewModel emitterViewModel);

        /// <summary>
        /// エミッタのインデックスを取得します。
        /// </summary>
        /// <param name="emitterViewModel">エミッタビューモデル</param>
        /// <param name="viewModelIndex">ビューモデルのインデックス</param>
        /// <param name="dataModelIndex">データモデルのインデックス</param>
        void GetEmitterIndex(
            EmitterViewModel emitterViewModel,
            out int viewModelIndex,
            out int dataModelIndex);

        /// <summary>
        /// エミッタを指定インデックスに追加します。
        /// </summary>
        /// <param name="emitterViewModel">エミッタビューモデル</param>
        /// <param name="viewModelIndex">ビューモデルのインデックス</param>
        /// <param name="dataModelIndex">データモデルのインデックス</param>
        /// <returns>処理が成功したときtrueを返します。</returns>
        bool InsertEmitter(
            EmitterViewModel emitterViewModel,
            int viewModelIndex,
            int dataModelIndex);
    }
}
