﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// RandomFe1Dataに対応するビューモデルです。
    /// </summary>
    public class RandomFe1BasicViewModel : PropertyPageViewModel<RandomFe1Data>, IModificationFlagOwner
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="parent">親ビューモデル</param>
        /// <param name="dataModel">RandomFe1Data</param>
        public RandomFe1BasicViewModel(HierarchyViewModel parent, RandomFe1Data dataModel)
            : base(parent, dataModel)
        {
            // ランダムグループのビューモデルを作成
            this.RandomFe1BasicParamViewModel = new RandomFe1BasicParamViewModel(
                this, dataModel.RandomFe1ParamData);
            this.Children.Add(this.RandomFe1BasicParamViewModel);

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// SpinBasicParamViewModelを取得または設定します。
        /// </summary>
        public RandomFe1BasicParamViewModel RandomFe1BasicParamViewModel { get; private set; }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
