﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Runtime.CompilerServices;
using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;
using EffectMaker.UILogic.Attributes;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// RandomFe1ParamDataに対応するビューモデルです。
    /// </summary>
    public class RandomFe1BasicParamViewModel : CurveEditorOwnerViewModel<RandomFe1ParamData>, IModificationFlagOwner
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="parent">親ビューモデル</param>
        /// <param name="dataModel">RandomFe1ParamData</param>
        public RandomFe1BasicParamViewModel(HierarchyViewModel parent, RandomFe1ParamData dataModel)
            : base(parent, dataModel)
        {
            this.SetDefaultSnapSetting("FieldGpuNoiseBasic");
            this.DefaultValue = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            var table = this.GetDataModelValue<AnimationTableData>("AnimationTable");
            if (table.Count == 0)
            {
                this.InitData();
            }

            // デフォルト値を更新
            this.UpdatePropertyDescriptors();

            var randomCurveProperties = EnumerableUtility.Enumerate(
                    ViewModelBase.NameOf(() => dataModel.EnableAnimation),
                    ViewModelBase.NameOf(() => dataModel.AnimationTable),
                    ViewModelBase.NameOf(() => dataModel.LoopMode),
                    ViewModelBase.NameOf(() => dataModel.LoopEnd),
                    ViewModelBase.NameOf(() => dataModel.Randomize),
                    ViewModelBase.NameOf(() => dataModel.RandomRange));

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            var mmfvm = new MultipleModificationFlagsViewModel(this);
            mmfvm.SetPropertyDictionary("RandomFe1Curve", randomCurveProperties);
            this.ModificationFlagViewModel = mmfvm;
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
