﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;
using EffectMaker.UILogic.Attributes;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the RandomBasicParamViewModel.
    /// </summary>
    public class RandomBasicParamViewModel : CurveEditorOwnerViewModel, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public RandomBasicParamViewModel(HierarchyViewModel parent, RandomParamData dataModel)
            : base(parent, dataModel)
        {
            this.OnValueChangedExecutable = new AnonymousExecutable(this.OnValueChanged);
            this.DefaultValue = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            var table = this.GetDataModelValue<AnimationTableData>("AnimationTable");
            if (table.Count == 0)
            {
                this.InitData();
            }

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// Gets or sets a value indicating whether enable animation.
        /// </summary>
        [UseDataModelOriginalValue]
        public bool EnableAnimation
        {
            get
            {
                return (this.Proxy.DataModel as RandomParamData).EnableAnimation == 1;
            }

            set
            {
                var intValue = value ? 1 : 0;
                var binder = new EffectMaker.Foundation.Dynamic.EffectMakerSetMemberBinder(
                    ViewModelBase.GetPropertyNameString(() => this.EnableAnimation), false, true);
                this.TrySetMember(binder, intValue);

                // プロパティ変更通知.
                this.OnPropertyChanged("EnableAnimation");
                this.OnPropertyChanged("EnableConstitution");
            }
        }

        /// <summary>
        /// Gets a value indicating whether enable constitution.
        /// </summary>
        public bool EnableConstitution
        {
            get
            {
                return (this.Proxy.DataModel as RandomParamData).EnableAnimation == 0;
            }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel
        {
            get;
            private set;
        }

        /// <summary>
        /// Get an executable to run when an value changes.
        /// </summary>
        public IExecutable OnValueChangedExecutable
        {
            get;
            private set;
        }
    }
}
