﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;
using EffectMaker.UILogic.Attributes;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the CustomBasicParamViewModel.
    /// </summary>
    public class CustomBasicValueViewModel : PropertyGroupViewModel<CustomFieldValueData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public CustomBasicValueViewModel(
            HierarchyViewModel parent, CustomFieldValueData dataModel)
            : base(parent, dataModel)
        {
            // デフォルト値を更新
            this.UpdatePropertyDescriptors();

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);

            // データ変更フラグをクリア。
            this.ModificationFlagViewModel.ClearModificationFlags();
            this.ModificationFlagViewModel.ClearChildModificationFlags();
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }

        /// <summary>
        /// 数値0のラベルを取得します.
        /// </summary>
        public string Value0Label
        {
            get { return GetValuelabel(0); }
        }

        /// <summary>
        /// 数値1のラベルを取得します.
        /// </summary>
        public string Value1Label
        {
            get { return GetValuelabel(1); }
        }

        /// <summary>
        /// 数値2のラベルを取得します.
        /// </summary>
        public string Value2Label
        {
            get { return GetValuelabel(2); }
        }

        /// <summary>
        /// 数値3のラベルを取得します.
        /// </summary>
        public string Value3Label
        {
            get { return GetValuelabel(3); }
        }

        /// <summary>
        /// 数値4のラベルを取得します.
        /// </summary>
        public string Value4Label
        {
            get { return GetValuelabel(4); }
        }

        /// <summary>
        /// 数値5のラベルを取得します.
        /// </summary>
        public string Value5Label
        {
            get { return GetValuelabel(5); }
        }

        /// <summary>
        /// 数値6のラベルを取得します.
        /// </summary>
        public string Value6Label
        {
            get { return GetValuelabel(6); }
        }

        /// <summary>
        /// 数値7のラベルを取得します.
        /// </summary>
        public string Value7Label
        {
            get { return GetValuelabel(7); }
        }

        /// <summary>
        /// 数値8のラベルを取得します.
        /// </summary>
        public string Value8Label
        {
            get { return GetValuelabel(8); }
        }

        /// <summary>
        /// 数値9のラベルを取得します.
        /// </summary>
        public string Value9Label
        {
            get { return GetValuelabel(9); }
        }

        /// <summary>
        /// 数値10のラベルを取得します.
        /// </summary>
        public string Value10Label
        {
            get { return GetValuelabel(10); }
        }

        /// <summary>
        /// 数値11のラベルを取得します.
        /// </summary>
        public string Value11Label
        {
            get { return GetValuelabel(11); }
        }

        /// <summary>
        /// 数値12のラベルを取得します.
        /// </summary>
        public string Value12Label
        {
            get { return GetValuelabel(12); }
        }

        /// <summary>
        /// 数値13のラベルを取得します.
        /// </summary>
        public string Value13Label
        {
            get { return GetValuelabel(13); }
        }

        /// <summary>
        /// 数値14のラベルを取得します.
        /// </summary>
        public string Value14Label
        {
            get { return GetValuelabel(14); }
        }

        /// <summary>
        /// 数値15のラベルを取得します.
        /// </summary>
        public string Value15Label
        {
            get { return GetValuelabel(15); }
        }

        /// <summary>
        /// オプションを変更したときの処理を行います.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The event arguments.</param>
        protected override void OnOptionChanged(object sender, EventArgs e)
        {
            base.OnOptionChanged(sender, e);
            for (int i = 0; i < 16; ++i)
            {
                this.OnPropertyChanged(string.Format("Value{0}Label", i));
            }
        }

        /// <summary>
        /// ラベルを取得します。
        /// </summary>
        /// <param name="index">ラベルのindex</param>
        /// <returns>ラベル</returns>
        private static string GetValuelabel(int index)
        {
            var setting = OptionStore.ProjectConfig.CustomFieldDataSetting;

            if (index < setting.FloatLabel.Count)
            {
                return setting.FloatLabel[index];
            }
            else
            {
                return string.Format(Properties.Resources.CustomFieldValue, index);
            }
        }
    }
}
