﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the EmitterData.
    /// </summary>
    public class EmitterEmissionViewModel : PropertyPageViewModel<EmitterEmissionData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterEmissionViewModel(HierarchyViewModel parent, EmitterEmissionData dataModel)
            : base(parent, dataModel)
        {
            this.EmitterEmissionTimingViewModel = new EmitterEmissionTimingViewModel(
                this, dataModel.EmitterEmissionTimingData);
            this.Children.Add(this.EmitterEmissionTimingViewModel);

            this.EmitterEmissionVelocityViewModel = new EmitterEmissionVelocityViewModel(
                this, dataModel.EmitterEmissionVelocityData);
            this.Children.Add(this.EmitterEmissionVelocityViewModel);

            this.EmitterEmissionGravityViewModel = new EmitterEmissionGravityViewModel(
                this, dataModel.EmitterEmissionGravityData);
            this.Children.Add(this.EmitterEmissionGravityViewModel);

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// EmitterEmissionTimingViewModel.
        /// </summary>
        public EmitterEmissionTimingViewModel EmitterEmissionTimingViewModel
        {
            get; private set;
        }

        /// <summary>
        /// EmitterEmissionVelocityViewModel.
        /// </summary>
        public EmitterEmissionVelocityViewModel EmitterEmissionVelocityViewModel
        {
            get; private set;
        }

        /// <summary>
        /// EmitterEmissionGravityViewModel.
        /// </summary>
        public EmitterEmissionGravityViewModel EmitterEmissionGravityViewModel
        {
            get; private set;
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel
        {
            get;
            private set;
        }
    }
}
