﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

using EffectMaker.BusinessLogic.IO;

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Manager;
using EffectMaker.DataModel.Specific.DataModels;

using EffectMaker.DataModelLogic.DataModelProxies;
using EffectMaker.DataModelLogic.Utilities;

using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.Dynamic;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Log;

using EffectMaker.UILogic.Properties;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// エミッタカスタムシェーダビューモデル
    /// </summary>
    public class EmitterCustomShaderViewModel : PropertyPageViewModel<EmitterCustomShaderData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterCustomShaderViewModel(
            HierarchyViewModel parent,
            EmitterCustomShaderData dataModel)
            : base(parent, dataModel)
        {
            this.EmitterCustomShaderGroupViewModel = new EmitterCustomShaderGroupViewModel(this, dataModel);
            this.EmitterCustomShaderBasicViewModel =
                new EmitterCustomShaderBasicViewModel(this, dataModel, this.EmitterCustomShaderGroupViewModel);

            this.Children.Add(this.EmitterCustomShaderBasicViewModel);
            this.Children.Add(this.EmitterCustomShaderGroupViewModel);

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// インデックスビューモデル
        /// </summary>
        public EmitterCustomShaderBasicViewModel EmitterCustomShaderBasicViewModel { get; set; }

        /// <summary>
        /// グループビューモデル
        /// </summary>
        public EmitterCustomShaderGroupViewModel EmitterCustomShaderGroupViewModel { get; set; }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
