﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;
using EffectMaker.Foundation.Command;
using EffectMaker.Foundation.EventArguments;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the EmitterData.
    /// </summary>
    public class EmitterBasicViewModel : PropertyPageViewModel<EmitterBasicSettingData>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterBasicViewModel(HierarchyViewModel parent, EmitterBasicSettingData dataModel)
            : base(parent, dataModel)
        {

            // EmitterBasicBasicViewModel生成時に、EmitterBasicRenderViewModelを参照するので、１番最後にした
            this.EmitterBasicRandomViewModel = new EmitterBasicRandomViewModel(
                this, dataModel.EmitterBasicRandomData);
            this.EmitterBasicRenderViewModel = new EmitterBasicRenderViewModel(
                this, dataModel.EmitterBasicRenderData);
            this.EmitterBasicLodViewModel = new EmitterBasicLodViewModel(
                this, dataModel.EmitterBasicLodData);
            this.EmitterBasicInheritanceViewModel = new EmitterBasicInheritanceViewModel(
                this, dataModel.EmitterBasicInheritanceData);
            this.EmitterBasicBasicViewModel = new EmitterBasicBasicViewModel(
                this, dataModel.EmitterBasicBasicData);

            // Childrenへの追加は元の順番通りに行う
            this.Children.Add(this.EmitterBasicBasicViewModel);
            this.Children.Add(this.EmitterBasicRandomViewModel);
            this.Children.Add(this.EmitterBasicRenderViewModel);
            this.Children.Add(this.EmitterBasicLodViewModel);
            this.Children.Add(this.EmitterBasicInheritanceViewModel);

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// EmitterBasicBasicViewModel.
        /// </summary>
        public EmitterBasicBasicViewModel EmitterBasicBasicViewModel { get; private set; }

        /// <summary>
        /// EmitterBasicRandomViewModel.
        /// </summary>
        public EmitterBasicRandomViewModel EmitterBasicRandomViewModel { get; private set; }

        /// <summary>
        /// EmitterBasicRenderViewModel.
        /// </summary>
        public EmitterBasicRenderViewModel EmitterBasicRenderViewModel { get; private set; }

        /// <summary>
        /// EmitterBasicLodViewModel.
        /// </summary>
        public EmitterBasicLodViewModel EmitterBasicLodViewModel { get; private set; }

        /// <summary>
        /// EmitterBasicInheritanceViewModel.
        /// </summary>
        public EmitterBasicInheritanceViewModel EmitterBasicInheritanceViewModel { get; private set; }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
