﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.BusinessLogic.DataModelOperation;
using EffectMaker.BusinessLogic.UserData;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Manager;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.Events;
using EffectMaker.Foundation.Collections.Generic;
using EffectMaker.Foundation.Extensions;

namespace EffectMaker.DataModelLogic.DataModelProxies
{
    /// <summary>
    /// Data model proxy for Emitter Extension Parameters.
    /// </summary>
    public class EmitterExtParamsProxy : DataModelProxy
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="dataModel">The data model for the proxy.</param>
        public EmitterExtParamsProxy(DataModelBase dataModel) :
            base(dataModel)
        {
        }

        /// <summary>
        /// Update user data models.
        /// </summary>
        public void UpdateUserData()
        {
            var dataModel = this.DataModel as EmitterExtParams;

            // Create user data models.
            IEnumerable<UserDataBase> userDataModels =
                UserDataManager.CreateUserDataForOwner(typeof(EmitterExtParams));

            // Set the created user data models to our data model.
            dataModel.EmitterExtParamsSettingData = (EmitterExtParamsSettingData)userDataModels.FirstOrDefault();

            // Fire event.
            this.TriggerPropertyModifiedEvent("EmitterExtParamsSettingData");
        }
    }
}
