﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class PreviewBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static PreviewBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var previewBinary = new BinaryStructDefinition(typeof(PreviewData)) { HasBinaryHeader = true };

            // Output : startFrame
            // Inputs : PreviewStartFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("BasicSettingData.PreviewBasicPlaybackData.PreviewStartFrame", new Guid("079df94b-a6b8-435e-9885-2eb18a08266b"))
            );

            // Output : forceStartFrame
            // Inputs : PreviewEndFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("BasicSettingData.PreviewBasicPlaybackData.PreviewEndFrame", new Guid("5d11e7e3-5044-4b4a-a4d2-aff740329f50"))
            );

            // Output : isManualEmitter
            // Inputs : IsManualEmitter
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("BasicSettingData.PreviewBasicPlaybackData.IsManualEmitter", new Guid("5ec61b5e-e88e-49cc-9450-5097e85089d7"))
            );

            // Output : dummy
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                3,
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : emitterInverval
            // Inputs : EmitterInterval
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("BasicSettingData.PreviewBasicPlaybackData.EmitterInterval", new Guid("6ded2c00-c0da-4029-afec-0476b72a9166"))
            );

            // Output : maxEmitCountPerFrame
            // Inputs : MaxEmitCountPerFrame
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("BasicSettingData.PreviewBasicPlaybackData.MaxEmitCountPerFrame", new Guid("49b8c593-41fe-4d99-a5f4-4ebe57337a41"))
            );

            // Output : color
            // Inputs : Color
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ColorData.Color", new Guid("21a63b0f-9d62-4e47-9181-103e2444ddc7"))
            );

            // Output : emissionRate
            // Inputs : EmissionRate
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ParticleEmissionData.EmissionRate", new Guid("92a2d12c-5c6e-462a-8505-0518f7c9fa19"))
            );

            // Output : emissionInterval
            // Inputs : EmissionInterval
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ParticleEmissionData.EmissionInterval", new Guid("03455062-4d17-47fa-a5bf-5eccb2083dd5"))
            );

            // Output : particleScale
            // Inputs : ParticleScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ParticleScaleData.ParticleScale", new Guid("bf1d9d03-5689-424f-9cfc-393e8cf570a7"))
            );

            // Output : emissionParticleScale
            // Inputs : EmissionParticleScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ParticleScaleData.EmissionParticleScale", new Guid("ec0c0e28-2025-49e4-8b98-2bf0153c24eb"))
            );

            // Output : emitterVolumeScale
            // Inputs : EmitterScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EmitterData.EmitterScale", new Guid("1729c2c9-6de6-4676-9624-65c09e23b051"))
            );

            // Output : life
            // Inputs : LifeScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ParticleControlData.LifeScale", new Guid("0adb872e-6afe-4e44-9048-e50caa285a05"))
            );

            // Output : allDirectionVel
            // Inputs : SetAllDirectionalVelScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ParticleEmissionData.SetAllDirectionalVelScale", new Guid("583f5076-a5bc-430d-a1a2-5ed06d9f60e1"))
            );

            // Output : directionalVel
            // Inputs : SetDirectionalVelScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ParticleEmissionData.SetDirectionalVelScale", new Guid("ac8667a2-2d77-48e1-a202-34d28f2ae9cc"))
            );

            // Output : randomVel
            // Inputs : SetRandomVelScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ParticleEmissionData.SetRandomVelScale", new Guid("d9bed353-1219-45ba-9bca-5cc1031d621a"))
            );

            // Output : addVel
            // Inputs : SetAddVelValue
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ParticleEmissionData.SetAddVelValue", new Guid("ae495e96-e823-4d52-9650-9b87fa6f9c6e"))
            );

            // Output : emitterColor0
            // Inputs : EmitterColor0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorToVec3Converter)),
                null,
                new InputPropertyDefinition("ColorData.EmitterColor0", new Guid("1ba8dfab-665c-4a91-9a9e-687fa8403db5"))
            );

            // Output : emitterColor1
            // Inputs : EmitterColor1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(ColorToVec3Converter)),
                null,
                new InputPropertyDefinition("ColorData.EmitterColor1", new Guid("23afecf9-373a-4d20-b47b-a815d52714ce"))
            );

            // Output : enableEmitterColor
            // Inputs : EnableEmitterColor
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (byte)1), new SwitchCase(false, (byte)0) }),
                    new ConverterParam("DefaultOutput", (byte)0)),
                null,
                new InputPropertyDefinition("ColorData.EnableEmitterColor", new Guid("74d5eed4-9520-4152-8fac-2741a603dfe6"))
            );

            // Output : dummy0
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                1,
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : dummy1
            // Inputs : None
            BinaryConversionInfoBase.AddFixedSizeFieldDefinition(
                2,
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null
            );

            // Output : matrixSetType
            // Inputs : MatrixType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixMatrixSettingsData.MatrixType", new Guid("cbdf5c95-c757-41dc-930e-122badc9343d"))
            );

            // Output : matrixApplyType
            // Inputs : MatrixApplyMode
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixModelRelationData.MatrixApplyMode", new Guid("eb57397e-86e4-42e0-8442-3e79fef2c3d1"))
            );

            // Output : modelGuid
            // Inputs : ModelGuid
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixModelRelationData.ModelGuid", new Guid("a0ef7bf4-bad5-4f26-a8fa-a3e970f91a92"))
            );

            // Output : boneIndex
            // Inputs : BoneIndex
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixModelRelationData.BoneIndex", new Guid("6008d239-972d-4981-9fe7-a311f5356a7d"))
            );

            // Output : offsetPosition
            // Inputs : OffsetPosition
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixOffsetMatrixData.OffsetPosition", new Guid("59d7cccb-beaf-4ae2-a0a3-5699d0332d5f"))
            );

            // Output : offsetScale
            // Inputs : OffsetScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixOffsetMatrixData.OffsetScale", new Guid("7d04f4d3-fbe9-464b-9006-94cbe27f3db4"))
            );

            // Output : offsetRotateX
            // Inputs : OffsetRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SelectPrimitiveChannelConverter),
                    new ConverterParam("ChannelIndex", 0),
                    new ConverterParam("RadianConvertMode", 1)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixOffsetMatrixData.OffsetRotation", new Guid("78934dfe-6b0c-4bbb-8b3d-9291b6aed0b7"))
            );

            // Output : offsetRotateY
            // Inputs : OffsetRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SelectPrimitiveChannelConverter),
                    new ConverterParam("ChannelIndex", 1),
                    new ConverterParam("RadianConvertMode", 1)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixOffsetMatrixData.OffsetRotation", new Guid("78934dfe-6b0c-4bbb-8b3d-9291b6aed0b7"))
            );

            // Output : offsetRotateZ
            // Inputs : OffsetRotation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(SelectPrimitiveChannelConverter),
                    new ConverterParam("ChannelIndex", 2),
                    new ConverterParam("RadianConvertMode", 1)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixOffsetMatrixData.OffsetRotation", new Guid("78934dfe-6b0c-4bbb-8b3d-9291b6aed0b7"))
            );

            // Output : isEmitterBillboard
            // Inputs : EmitterBillboardType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("PreviewMatrixData.PreviewMatrixOffsetMatrixData.EmitterBillboardType", new Guid("72343577-9f8a-448a-beb9-6eb81a71ad35"))
            );

            // Output : moveType
            // Inputs : MoveType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.MoveType", new Guid("adac800f-172f-42f7-b959-891ae2b9d314"))
            );

            // Output : radiusXZ
            // Inputs : MoveRadiusXZ
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.MoveRadiusXZ", new Guid("fa26a663-1d8d-48a0-9437-642a37a1678e"))
            );

            // Output : speedXZ
            // Inputs : MoveSpeedXZ
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.MoveSpeedXZ", new Guid("f8b9ab81-df61-4689-a31e-a556df040551"))
            );

            // Output : distance
            // Inputs : MoveDistance
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.MoveDistance", new Guid("679f82e5-ddb0-45e8-860f-7aee25e29d65"))
            );

            // Output : moveSpeed
            // Inputs : MoveSpeed
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.MoveSpeed", new Guid("8c44ee73-b556-4e63-a0fd-c1aefecbb8c2"))
            );

            // Output : amplitudeY
            // Inputs : ShakeAmplitudeY
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.ShakeAmplitudeY", new Guid("93e16459-d576-4ce5-af5e-707b43b853a9"))
            );

            // Output : speedY
            // Inputs : ShakeSpeedY
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.ShakeSpeedY", new Guid("12dae9ab-66ec-4cb8-ae0b-9c4b4135abed"))
            );

            // Output : rollZ
            // Inputs : RollSpeedZ
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.RollSpeedZ", new Guid("3847865c-3c85-4b1f-9847-694f6d3499f1"))
            );

            // Output : straightDirection
            // Inputs : StraightDirection
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.StraightDirection", new Guid("1f8aa007-e16d-4279-98c6-5594bdd7d966"))
            );

            // Output : straightAngle
            // Inputs : StraightAngle
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                previewBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("AutoMoveData.StraightAngle", new Guid("b9dd4ade-2858-476d-9311-9fbe51cb3a93"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = previewBinary;

            //-----------------------------------------------------------------
            // Register events.
            //-----------------------------------------------------------------
            BinaryConversionInfoManager.DataModelCreated   += OnDataModelCreated;
            BinaryConversionInfoManager.DataModelDestroyed += OnDataModelDestroyed;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private PreviewBinaryConversionInfo(DataModelBase dataModel)
        {
            this.rootBinaryInstance = rootBinaryDefinition.CreateInstance(null, dataModel);
            this.rootBinaryInstance.ConvertBinary();
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            // Dispose the binary structure instance.
            if (this.rootBinaryInstance != null)
            {
                this.rootBinaryInstance.Dispose();
            }
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            if (typeof(PreviewData).IsInstanceOfType(dataModel) == true)
            {
                var instance = new PreviewBinaryConversionInfo(dataModel);
                instanceMap.Add(dataModel, instance);

                SendModifiedBinaryContext.BeginSession();
                SendModifiedBinaryContext.AddBinaryStructToSend(instance.rootBinaryInstance);
                SendModifiedBinaryContext.EndSession();
            }
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            if (typeof(PreviewData).IsInstanceOfType(dataModel) == true)
            {
                if (instanceMap.ContainsKey(dataModel))
                {
                    var instance = instanceMap[dataModel];
                    instanceMap.Remove(dataModel);
                    instance.Dispose();
                }
            }
        }

    }
}
